package dev.openmobile.ui.components.inputs

import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.font.FontStyle
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.text.style.TextDecoration
import androidx.compose.ui.text.style.TextOverflow
import androidx.compose.ui.unit.TextUnit
import androidx.compose.ui.unit.sp
import androidx.core.graphics.toColorInt
import dev.openmobile.ui.utils.parseFromJson

@Composable
fun UIText(json: Map<*, *>) {
    /* Todo: missing attributes to mapping
    style: TextStyle = LocalTextStyle.current
    onTextLayout: (TextLayoutResult) -> Unit = {},
    fontFamily: FontFamily? = null
    */
    val attributes = json["attributes"] as Map<*, *>
    val color = Color((attributes["color"] as String?)?.toColorInt() ?: Color.Black.hashCode())
    val text = attributes["text"] as String? ?: ""
    val fontSize = (attributes["fontSize"] as Double?)?.sp ?: 16.0.sp
    val fontStyle = getFontStyle(attributes["fontStyle"] as String?)
    val fontWeight = FontWeight(attributes["fontWeight"] as Int? ?: FontWeight.Normal.weight)
    val letterSpacing = (attributes["letterSpacing"] as Int?)?.sp ?: TextUnit.Unspecified
    val textDecoration = getTextDecoration(attributes["textDecoration"] as String?)
    val textAlign = getTextAlign(attributes["textAlign"] as String?)
    val lineHeight = (attributes["lineHeight"] as Double?)?.sp ?: TextUnit.Unspecified
    val overflow = getTextOverflow(attributes["overflow"] as String?)
    val softWrap = attributes["softWrap"] as Boolean? ?: true
    val maxLines = attributes["maxLines"] as Int? ?: Int.MAX_VALUE
    val modifier = Modifier.parseFromJson(attributes["modifier"] as Map<*, *>?)
    return Text(
        text = text,
        color = color,
        fontStyle = fontStyle,
        fontSize = fontSize,
        fontWeight = fontWeight,
        letterSpacing = letterSpacing,
        textDecoration = textDecoration,
        textAlign = textAlign,
        lineHeight = lineHeight,
        overflow = overflow,
        softWrap = softWrap,
        maxLines = maxLines,
        modifier = modifier,
    )
}


fun getFontStyle(value: String?): FontStyle {
    return when (value) {
        "normal" -> FontStyle.Normal
        "italic" -> FontStyle.Italic
        else -> FontStyle.Normal
    }
}

fun getTextDecoration(value: String?): TextDecoration {
    return when (value) {
        "underline" -> TextDecoration.Underline
        "lineThrough" -> TextDecoration.LineThrough
        else -> TextDecoration.None
    }
}

fun getTextAlign(value: String?): TextAlign {
    return when (value) {
        "left" -> TextAlign.Left
        "start" -> TextAlign.Start
        "center" -> TextAlign.Center
        "end" -> TextAlign.End
        "right" -> TextAlign.Right
        "justify" -> TextAlign.Justify
        else -> TextAlign.Left
    }
}

fun getTextOverflow(value: String?): TextOverflow {
    return when (value) {
        "clip" -> TextOverflow.Clip
        "ellipsis" -> TextOverflow.Ellipsis
        "visible" -> TextOverflow.Visible
        else -> TextOverflow.Clip
    }
}
