package dev.openmobile.ui

import android.annotation.SuppressLint
import android.content.Context
import android.content.Intent
import android.os.Handler
import android.os.Looper
import android.util.Log
import android.widget.Toast
import dev.openmobile.core.ActionManager
import dev.openmobile.core.ActionType
import dev.openmobile.core.actions.UIActions

object UIManager {
    @SuppressLint("StaticFieldLeak")
    lateinit var client: Client

    fun initialize(context: Context) : Client {
        client = Client(context)
        return client
    }
}

class Client(val context: Context) : ActionManager {

    private fun buildAndLaunchIntent(json: String) {
        context.startActivity(buildIntent(json))
    }

    private fun buildIntent(json: String): Intent {
        val intent = Intent(context, LayoutActivity::class.java)
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
        intent.putExtra(LayoutActivity.LAYOUT_ACTIVITY_JSON_PARAM, json)
        return intent
    }

    override fun runAction(action: ActionType, attributes: Map<*, *>?) : Any? {
        when(action) {
            UIActions.LAUNCH_UI_INTENT -> {
                attributes?.let {
                    buildAndLaunchIntent(attributes["json"] as String)
                }
            }
            UIActions.BUILD_UI_INTENT -> {
                attributes?.let {
                    return buildIntent(attributes["json"] as String)
                }
            }
            UIActions.SHOW_TOAST -> {
                attributes?.let {
                    Log.i("OpenMobile ", "Network response :: $attributes")
                    val message = attributes["message"]
                    if (message == null || message !is String) {
                        Handler(Looper.getMainLooper()).post {
                            Toast.makeText(context,"Missing message attribute for Toast Message", Toast.LENGTH_SHORT).show()
                        }
                    }else {
                        Handler(Looper.getMainLooper()).post {
                            Toast.makeText(context,attributes["message"] as String, Toast.LENGTH_SHORT).show()
                        }
                    }
                }
            }
            else -> {}
        }
        return null
    }
}