package dev.openmobile.ui

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.os.Bundle
import android.util.Log
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Surface
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.tooling.preview.Preview
import com.jayway.jsonpath.JsonPath
import dev.openmobile.ui.utils.UIParser


class LayoutActivity : ComponentActivity() {
    companion object {
        const val LAYOUT_ACTIVITY_JSON_PARAM = "LAYOUT_ACTIVITY_JSON_PARAM"
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        val filter = IntentFilter()
        filter.addAction("dev.openmobile.ui.FINISH_ACTIVITY")
        registerReceiver(receiver, filter)
        val json =  intent.extras?.getString(LAYOUT_ACTIVITY_JSON_PARAM)
        setContent {
            Surface(
                modifier = Modifier.fillMaxSize(),
                color = MaterialTheme.colors.background
            ) {
                Layout(json)
            }
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        unregisterReceiver(receiver)
    }

    private val receiver: BroadcastReceiver = object : BroadcastReceiver() {
        override fun onReceive(context: Context, intent: Intent) {
            finish()
        }
    }
}

@Composable
fun Layout(jsonString: String?) {
    if (jsonString == null) Text(text = "Json not found")
    val json = JsonPath.parse(jsonString)
        .read("$") as Map<*, *>
    UIParser(json = json)
}

@Preview
@Composable
fun DefaultPreview() {
}
