/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.autoconfigure;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="openfga")
public class OpenFgaProperties
implements InitializingBean {
    private String apiUrl;
    private String storeId;
    private String authorizationModelId;
    private Credentials credentials;

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    public void setAuthorizationModelId(String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public void afterPropertiesSet() throws Exception {
        this.validate();
    }

    public void validate() {
        Credentials credentialsProperty = this.getCredentials();
        if (credentialsProperty != null) {
            CredentialsMethod credentialsMethod = this.getCredentials().getMethod();
            if (credentialsMethod == null) {
                throw new IllegalStateException("credentials method must not be null");
            }
            CredentialsConfiguration credentialsConfig = credentialsProperty.getConfig();
            switch (credentialsMethod) {
                case NONE: {
                    break;
                }
                case API_TOKEN: {
                    if (credentialsConfig != null && credentialsConfig.getApiToken() != null) break;
                    throw new IllegalStateException("'API_TOKEN' credentials method specified, but no token specified");
                }
                case CLIENT_CREDENTIALS: {
                    if (credentialsConfig != null && credentialsConfig.getApiTokenIssuer() != null && credentialsConfig.getClientId() != null && credentialsConfig.getClientSecret() != null) break;
                    throw new IllegalStateException("'CLIENT_CREDENTIALS' configuration must contain 'client-id', 'client-secret', and 'api-token-issuer'");
                }
                default: {
                    throw new IllegalStateException("credentials method must be either 'NONE', 'API_TOKEN', or 'CLIENT_CREDENTIALS'");
                }
            }
        }
    }

    public static class Credentials {
        private CredentialsMethod method;
        private CredentialsConfiguration config;

        public CredentialsMethod getMethod() {
            return this.method;
        }

        public void setMethod(CredentialsMethod method) {
            this.method = method;
        }

        public CredentialsConfiguration getConfig() {
            return this.config;
        }

        public void setConfig(CredentialsConfiguration config) {
            this.config = config;
        }
    }

    public static enum CredentialsMethod {
        NONE,
        API_TOKEN,
        CLIENT_CREDENTIALS;

    }

    public static class CredentialsConfiguration {
        private String apiToken;
        private String apiTokenIssuer;
        private String apiAudience;
        private String clientId;
        private String clientSecret;
        private String scopes;

        public String getApiTokenIssuer() {
            return this.apiTokenIssuer;
        }

        public void setApiTokenIssuer(String apiTokenIssuer) {
            this.apiTokenIssuer = apiTokenIssuer;
        }

        public String getApiAudience() {
            return this.apiAudience;
        }

        public void setApiAudience(String apiAudience) {
            this.apiAudience = apiAudience;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public String getApiToken() {
            return this.apiToken;
        }

        public void setApiToken(String apiToken) {
            this.apiToken = apiToken;
        }

        public String getScopes() {
            return this.scopes;
        }

        public void setScopes(String scopes) {
            this.scopes = scopes;
        }
    }
}

