/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.autoconfigure;

import dev.openfga.OpenFga;
import dev.openfga.autoconfigure.ConditionalOnFgaProperties;
import dev.openfga.autoconfigure.OpenFgaProperties;
import dev.openfga.sdk.api.client.OpenFgaClient;
import dev.openfga.sdk.api.configuration.ApiToken;
import dev.openfga.sdk.api.configuration.ClientConfiguration;
import dev.openfga.sdk.api.configuration.ClientCredentials;
import dev.openfga.sdk.api.configuration.Credentials;
import dev.openfga.sdk.api.configuration.CredentialsMethod;
import dev.openfga.sdk.errors.FgaInvalidParameterException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnFgaProperties
@EnableConfigurationProperties(value={OpenFgaProperties.class})
public class OpenFgaAutoConfiguration {
    private final OpenFgaProperties openFgaProperties;

    public OpenFgaAutoConfiguration(OpenFgaProperties openFgaProperties) {
        this.openFgaProperties = openFgaProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public ClientConfiguration fgaConfig() {
        Credentials credentials = new Credentials();
        OpenFgaProperties.Credentials credentialsProperties = this.openFgaProperties.getCredentials();
        if (credentialsProperties != null) {
            if (OpenFgaProperties.CredentialsMethod.API_TOKEN.equals((Object)credentialsProperties.getMethod())) {
                credentials.setCredentialsMethod(CredentialsMethod.API_TOKEN);
                credentials.setApiToken(new ApiToken(credentialsProperties.getConfig().getApiToken()));
            } else if (OpenFgaProperties.CredentialsMethod.CLIENT_CREDENTIALS.equals((Object)credentialsProperties.getMethod())) {
                ClientCredentials clientCredentials = new ClientCredentials().clientId(credentialsProperties.getConfig().getClientId()).clientSecret(credentialsProperties.getConfig().getClientSecret()).apiTokenIssuer(credentialsProperties.getConfig().getApiTokenIssuer()).apiAudience(credentialsProperties.getConfig().getApiAudience()).scopes(credentialsProperties.getConfig().getScopes());
                credentials.setCredentialsMethod(CredentialsMethod.CLIENT_CREDENTIALS);
                credentials.setClientCredentials(clientCredentials);
            }
        }
        return new ClientConfiguration().apiUrl(this.openFgaProperties.getApiUrl()).storeId(this.openFgaProperties.getStoreId()).authorizationModelId(this.openFgaProperties.getAuthorizationModelId()).credentials(credentials);
    }

    @Bean
    @ConditionalOnMissingBean
    public OpenFgaClient fgaClient(ClientConfiguration configuration) {
        try {
            return new OpenFgaClient(configuration);
        }
        catch (FgaInvalidParameterException e) {
            throw new BeanCreationException("Failed to create OpenFgaClient", (Throwable)e);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public OpenFga fga(OpenFgaClient openFgaClient) {
        return new OpenFga(openFgaClient);
    }
}

