/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga;

import dev.openfga.OpenFgaCheckException;
import dev.openfga.sdk.api.client.OpenFgaClient;
import dev.openfga.sdk.api.client.model.ClientCheckRequest;
import dev.openfga.sdk.api.client.model.ClientCheckResponse;
import dev.openfga.sdk.errors.FgaInvalidParameterException;
import java.util.concurrent.ExecutionException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class OpenFga {
    private final OpenFgaClient fgaClient;

    public OpenFga(OpenFgaClient fgaClient) {
        this.fgaClient = fgaClient;
    }

    public boolean check(String objectType, String objectId, String relation, String userType) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new IllegalStateException("No user provided, and no authentication could be found in the security context");
        }
        return this.check(objectType, objectId, relation, userType, authentication.getName());
    }

    public boolean check(String objectType, String objectId, String relation, String userType, String userId) {
        ClientCheckRequest body = new ClientCheckRequest().user(String.format("%s:%s", userType, userId)).relation(relation)._object(String.format("%s:%s", objectType, objectId));
        try {
            return Boolean.TRUE.equals(((ClientCheckResponse)this.fgaClient.check(body).get()).getAllowed());
        }
        catch (FgaInvalidParameterException | InterruptedException | ExecutionException e) {
            throw new OpenFgaCheckException("Error performing FGA check", e);
        }
    }
}

