/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.testing.xctest.internal.plugins;

import com.google.common.collect.ImmutableList;
import dev.nokee.platform.ios.tasks.internal.CreateIosApplicationBundleTask;
import dev.nokee.platform.ios.tasks.internal.ProcessPropertyListTask;
import dev.nokee.platform.ios.tasks.internal.SignIosApplicationBundleTask;
import dev.nokee.testing.xctest.internal.plugins.XCTestRules;
import dev.nokee.testing.xctest.tasks.internal.CreateIosXCTestBundleTask;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.util.GUtil;

public abstract class ObjectiveCXCTestTestSuitePlugin
implements Plugin<Project> {
    @Inject
    protected abstract TaskContainer getTasks();

    @Inject
    protected abstract ProjectLayout getLayout();

    @Inject
    protected abstract ProviderFactory getProviders();

    public void apply(Project project) {
        project.getPluginManager().withPlugin("dev.nokee.objective-c-ios-application", appliedPlugin -> {
            project.getPluginManager().apply(XCTestRules.class);
            String moduleName = GUtil.toCamelCase((CharSequence)project.getName());
            TaskProvider processUnitTestPropertyListTask = this.getTasks().register("processUnitTestPropertyList", ProcessPropertyListTask.class, task -> {
                task.getIdentifier().set(project.provider(() -> project.getGroup().toString() + "." + moduleName + "UnitTest"));
                task.getModule().set((Object)(moduleName + "UnitTest"));
                task.getSources().from(new Object[]{"src/unitTest/resources/Info.plist"});
                task.getOutputFile().set(this.getLayout().getBuildDirectory().file("ios/unitTest/Info.plist"));
            });
            TaskProvider createUnitTestXCTestBundle = this.getTasks().register("createUnitTestXCTestBundle", CreateIosXCTestBundleTask.class, task -> {
                task.getXCTestBundle().set(this.getLayout().getBuildDirectory().file("ios/products/unitTest/" + moduleName + "UnitTest-unsigned.xctest"));
                task.getSources().from(new Object[]{processUnitTestPropertyListTask.flatMap(it -> it.getOutputFile())});
            });
            TaskProvider signUnitTestXCTestBundle = this.getTasks().register("signUnitTestXCTestBundle", SignIosApplicationBundleTask.class, task -> {
                task.getUnsignedApplicationBundle().set(createUnitTestXCTestBundle.flatMap(CreateIosXCTestBundleTask::getXCTestBundle));
                task.getSignedApplicationBundle().set(this.getLayout().getBuildDirectory().file("ios/products/unitTest/" + moduleName + "UnitTest.xctest"));
            });
            TaskProvider createUnitTestApplicationBundleTask = this.getTasks().register("createUnitTestLauncherApplicationBundle", CreateIosApplicationBundleTask.class, task -> {
                TaskProvider createApplicationBundleTask = this.getTasks().named("createApplicationBundle", CreateIosApplicationBundleTask.class);
                task.getApplicationBundle().set(this.getLayout().getBuildDirectory().file("ios/products/unitTest/" + moduleName + "-unsigned.app"));
                task.getSources().from(new Object[]{createApplicationBundleTask.map(CreateIosApplicationBundleTask::getSources)});
                task.getPlugIns().from(new Object[]{signUnitTestXCTestBundle.flatMap(SignIosApplicationBundleTask::getSignedApplicationBundle)});
                task.getFrameworks().from(new Object[]{this.getXCTestBundleInjectDynamicLibrary()});
                task.getFrameworks().from(new Object[]{this.getXCTestFrameworks()});
            });
            this.getTasks().register("signUnitTestLauncherApplicationBundle", SignIosApplicationBundleTask.class, task -> {
                task.getUnsignedApplicationBundle().set(createUnitTestApplicationBundleTask.flatMap(CreateIosApplicationBundleTask::getApplicationBundle));
                task.getSignedApplicationBundle().set(this.getLayout().getBuildDirectory().file("ios/products/unitTest/" + moduleName + ".app"));
            });
            TaskProvider processUiTestPropertyListTask = this.getTasks().register("processUiTestPropertyList", ProcessPropertyListTask.class, task -> {
                task.getIdentifier().set(project.provider(() -> project.getGroup().toString() + "." + moduleName + "UiTest"));
                task.getModule().set((Object)(moduleName + "UiTest"));
                task.getSources().from(new Object[]{"src/uiTest/resources/Info.plist"});
                task.getOutputFile().set(this.getLayout().getBuildDirectory().file("ios/uiTest/Info.plist"));
            });
            TaskProvider createUiTestXCTestBundle = this.getTasks().register("createUiTestXCTestBundle", CreateIosXCTestBundleTask.class, task -> {
                task.getXCTestBundle().set(this.getLayout().getBuildDirectory().file("ios/products/uiTest/" + moduleName + "UiTest-Runner-unsigned.xctest"));
                task.getSources().from(new Object[]{processUiTestPropertyListTask.flatMap(it -> it.getOutputFile())});
            });
            TaskProvider signUiTestXCTestBundle = this.getTasks().register("signUiTestXCTestBundle", SignIosApplicationBundleTask.class, task -> {
                task.getUnsignedApplicationBundle().set(createUiTestXCTestBundle.flatMap(CreateIosXCTestBundleTask::getXCTestBundle));
                task.getSignedApplicationBundle().set(this.getLayout().getBuildDirectory().file("ios/products/uiTest/" + moduleName + "UiTest.xctest"));
            });
            TaskProvider createUiTestApplicationBundleTask = this.getTasks().register("createUiTestLauncherApplicationBundle", CreateIosApplicationBundleTask.class, task -> {
                task.getApplicationBundle().set(this.getLayout().getBuildDirectory().file("ios/products/uiTest/" + moduleName + "UiTest-Runner-unsigned.app"));
                task.getSources().from(new Object[]{this.getXCTRunner()});
                task.getPlugIns().from(new Object[]{signUiTestXCTestBundle.flatMap(SignIosApplicationBundleTask::getSignedApplicationBundle)});
                task.getFrameworks().from(new Object[]{this.getXCTestFrameworks()});
            });
            this.getTasks().register("signUiTestLauncherApplicationBundle", SignIosApplicationBundleTask.class, task -> {
                task.getUnsignedApplicationBundle().set(createUiTestApplicationBundleTask.flatMap(CreateIosApplicationBundleTask::getApplicationBundle));
                task.getSignedApplicationBundle().set(this.getLayout().getBuildDirectory().file("ios/products/uiTest/" + moduleName + "UiTest-Runner.app"));
            });
        });
    }

    private Provider<File> getXCTestBundleInjectDynamicLibrary() {
        return this.getProviders().provider(() -> new File(ObjectiveCXCTestTestSuitePlugin.getSdkPlatformPath(), "Developer/usr/lib/libXCTestBundleInject.dylib"));
    }

    private Provider<List<File>> getXCTestFrameworks() {
        return this.getProviders().provider(() -> ImmutableList.builder().add((Object)new File(ObjectiveCXCTestTestSuitePlugin.getSdkPlatformPath(), "Developer/Library/PrivateFrameworks/XCTAutomationSupport.framework")).add((Object)new File(ObjectiveCXCTestTestSuitePlugin.getSdkPlatformPath(), "Developer/usr/lib/libXCTestSwiftSupport.dylib")).add((Object)new File(ObjectiveCXCTestTestSuitePlugin.getSdkPlatformPath(), "Developer/Library/Frameworks/XCTest.framework")).build());
    }

    private Provider<File> getXCTRunner() {
        return this.getProviders().provider(() -> new File(ObjectiveCXCTestTestSuitePlugin.getSdkPlatformPath(), "Developer/Library/Xcode/Agents/XCTRunner.app/XCTRunner"));
    }

    public static String getSdkPlatformPath() {
        try {
            Process process = new ProcessBuilder("xcrun", "--sdk", "iphonesimulator", "--show-sdk-platform-path").start();
            process.waitFor();
            return IOUtils.toString((InputStream)process.getInputStream(), (Charset)Charset.defaultCharset()).trim();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

