/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.runtime.nativebase.internal;

import dev.nokee.runtime.base.internal.DefaultDimensionType;
import dev.nokee.runtime.base.internal.Dimension;
import dev.nokee.runtime.base.internal.DimensionType;
import dev.nokee.runtime.nativebase.OperatingSystemFamily;
import lombok.NonNull;
import org.gradle.api.Named;

public final class DefaultOperatingSystemFamily
implements OperatingSystemFamily,
Named,
Dimension {
    @NonNull
    private final String name;
    public static final DimensionType<DefaultOperatingSystemFamily> DIMENSION_TYPE = new DefaultDimensionType(DefaultOperatingSystemFamily.class);
    public static final DefaultOperatingSystemFamily WINDOWS = new DefaultOperatingSystemFamily("windows");
    public static final DefaultOperatingSystemFamily LINUX = new DefaultOperatingSystemFamily("linux");
    public static final DefaultOperatingSystemFamily MACOS = new DefaultOperatingSystemFamily("macos");
    public static final DefaultOperatingSystemFamily FREE_BSD = new DefaultOperatingSystemFamily("freebsd");
    public static final DefaultOperatingSystemFamily IOS = new DefaultOperatingSystemFamily("ios");
    public static final DefaultOperatingSystemFamily HOST = DefaultOperatingSystemFamily.forName(System.getProperty("os.name"));

    @Override
    public boolean isWindows() {
        return this.equals(WINDOWS);
    }

    @Override
    public boolean isLinux() {
        return this.equals(LINUX);
    }

    @Override
    public boolean isMacOs() {
        return this.equals(MACOS);
    }

    @Override
    public boolean isFreeBSD() {
        return this.equals(FREE_BSD);
    }

    @Override
    public boolean isIos() {
        return this.equals(IOS);
    }

    public static DefaultOperatingSystemFamily forName(String name) {
        String osName = name.toLowerCase();
        if (osName.contains("windows")) {
            return WINDOWS;
        }
        if (osName.contains("mac os x") || osName.contains("darwin") || osName.contains("osx") || osName.contains("macos")) {
            return MACOS;
        }
        if (osName.contains("linux")) {
            return LINUX;
        }
        if (osName.contains("freebsd")) {
            return FREE_BSD;
        }
        if (osName.contains("ios")) {
            return IOS;
        }
        throw new UnsupportedOperationException("Unsupported operating system family of name '" + osName + "'");
    }

    public DimensionType getType() {
        return DIMENSION_TYPE;
    }

    public DefaultOperatingSystemFamily(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultOperatingSystemFamily)) {
            return false;
        }
        DefaultOperatingSystemFamily other = (DefaultOperatingSystemFamily)o;
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultOperatingSystemFamily(name=" + this.getName() + ")";
    }
}

