/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.runtime.nativebase.internal;

import dev.nokee.runtime.base.internal.DefaultDimensionType;
import dev.nokee.runtime.base.internal.Dimension;
import dev.nokee.runtime.base.internal.DimensionType;
import dev.nokee.runtime.nativebase.MachineArchitecture;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.gradle.api.Named;

public abstract class DefaultMachineArchitecture
implements MachineArchitecture,
Named,
Dimension {
    @Nonnull
    private final String name;
    public static DimensionType<DefaultMachineArchitecture> DIMENSION_TYPE = new DefaultDimensionType(DefaultMachineArchitecture.class);
    public static DefaultMachineArchitecture X86 = new MachineArchitectureX86();
    public static DefaultMachineArchitecture X86_64 = new MachineArchitectureX86_64();
    public static DefaultMachineArchitecture HOST = DefaultMachineArchitecture.forName(System.getProperty("os.arch"));

    public static DefaultMachineArchitecture forName(String name) {
        String archName = name.toLowerCase();
        if (Arrays.asList("x86", "i386", "ia-32", "i686").contains(archName)) {
            return X86;
        }
        if (Arrays.asList("x86-64", "x86_64", "amd64", "x64").contains(archName)) {
            return X86_64;
        }
        throw new UnsupportedOperationException("Unsupported architecture of name '" + archName + "'");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultMachineArchitecture)) {
            return false;
        }
        DefaultMachineArchitecture other = (DefaultMachineArchitecture)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultMachineArchitecture;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    DefaultMachineArchitecture(@Nonnull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public static final class UnknownMachineArchitecture
    extends DefaultMachineArchitecture {
        public UnknownMachineArchitecture(String name) {
            super(name);
        }

        @Override
        public boolean is32Bit() {
            throw new UnsupportedOperationException("Unknown architecture");
        }

        @Override
        public boolean is64Bit() {
            throw new UnsupportedOperationException("Unknown architecture");
        }

        public DimensionType<DefaultMachineArchitecture> getType() {
            return DIMENSION_TYPE;
        }
    }

    private static final class MachineArchitectureX86_64
    extends DefaultMachineArchitecture {
        MachineArchitectureX86_64() {
            super("x86-64");
        }

        @Override
        public boolean is32Bit() {
            return false;
        }

        @Override
        public boolean is64Bit() {
            return true;
        }

        public DimensionType<DefaultMachineArchitecture> getType() {
            return DIMENSION_TYPE;
        }
    }

    private static final class MachineArchitectureX86
    extends DefaultMachineArchitecture {
        MachineArchitectureX86() {
            super("x86");
        }

        @Override
        public boolean is32Bit() {
            return true;
        }

        @Override
        public boolean is64Bit() {
            return false;
        }

        public DimensionType<DefaultMachineArchitecture> getType() {
            return DIMENSION_TYPE;
        }
    }
}

