/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.runtime.darwin.internal.plugins;

import dev.nokee.runtime.base.internal.plugins.FakeMavenRepositoryPlugin;
import dev.nokee.runtime.base.internal.repositories.NokeeServerService;
import dev.nokee.runtime.darwin.internal.FrameworkRouteHandler;
import dev.nokee.runtime.darwin.internal.locators.XcodebuildLocator;
import dev.nokee.runtime.darwin.internal.locators.XcrunLocator;
import dev.nokee.runtime.darwin.internal.plugins.CompatibilityRules;
import dev.nokee.runtime.nativebase.internal.ArtifactSerializationTypes;
import dev.nokee.runtime.nativebase.internal.ArtifactTypes;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistration;

public abstract class DarwinFrameworkResolutionSupportPlugin
implements Plugin<Project> {
    private static final Logger LOGGER = Logging.getLogger(DarwinFrameworkResolutionSupportPlugin.class);

    @Inject
    protected abstract ObjectFactory getObjects();

    public void apply(Project project) {
        project.getPluginManager().apply(CompatibilityRules.class);
        if (SystemUtils.IS_OS_MAC) {
            project.getPluginManager().apply(FakeMavenRepositoryPlugin.class);
            NokeeServerService.Parameters parameters = (NokeeServerService.Parameters)((BuildServiceRegistration)project.getGradle().getSharedServices().getRegistrations().getByName("nokeeServer")).getParameters();
            parameters.getRouteHandlers().add((Object)FrameworkRouteHandler.class.getCanonicalName());
            parameters.getToolLocators().add((Object)XcrunLocator.class.getCanonicalName());
            parameters.getToolLocators().add((Object)XcodebuildLocator.class.getCanonicalName());
            this.configure(project.getDependencies());
            project.getRepositories().withType(MavenArtifactRepository.class).configureEach(repo -> {
                if ("Nokee Local Repository".equals(repo.getName())) {
                    repo.mavenContent(content -> content.includeGroup("dev.nokee.framework"));
                }
            });
        } else {
            LOGGER.debug("Darwin framework resolution support is not configured because detected operating system is not macOS.");
        }
    }

    public void configure(DependencyHandler dependencies) {
        dependencies.artifactTypes(it -> {
            it.create("localpath", type -> type.getAttributes().attribute(ArtifactSerializationTypes.ARTIFACT_SERIALIZATION_TYPES_ATTRIBUTE, (Object)"serialized"));
            it.create("framework");
        });
        dependencies.registerTransform(DeserializeLocalFramework.class, variantTransform -> {
            variantTransform.getFrom().attribute(ArtifactTypes.ARTIFACT_TYPES_ATTRIBUTE, (Object)"localpath").attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)this.getObjects().named(LibraryElements.class, "framework-bundle"))).attribute(ArtifactSerializationTypes.ARTIFACT_SERIALIZATION_TYPES_ATTRIBUTE, (Object)"serialized");
            variantTransform.getTo().attribute(ArtifactTypes.ARTIFACT_TYPES_ATTRIBUTE, (Object)"framework").attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)this.getObjects().named(LibraryElements.class, "framework-bundle"))).attribute(ArtifactSerializationTypes.ARTIFACT_SERIALIZATION_TYPES_ATTRIBUTE, (Object)"deserialized");
        });
    }

    public static abstract class DeserializeLocalFramework
    implements TransformAction<TransformParameters.None> {
        @InputArtifact
        public abstract Provider<FileSystemLocation> getInputArtifact();

        public void transform(TransformOutputs outputs) {
            try {
                String s = FileUtils.readFileToString((File)((FileSystemLocation)this.getInputArtifact().get()).getAsFile(), (Charset)Charset.defaultCharset());
                File framework = new File(s);
                File o = outputs.dir((Object)framework.getName());
                if (!o.delete()) {
                    throw new RuntimeException("Can't delete file");
                }
                Files.createSymbolicLink(o.toPath(), framework.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

