/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.runtime.darwin.internal.plugins;

import dev.nokee.runtime.nativebase.internal.LibraryElements;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.attributes.AttributeCompatibilityRule;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.language.cpp.CppBinary;
import org.gradle.nativeplatform.Linkage;

public class CompatibilityRules
implements Plugin<Project> {
    private static final Logger LOGGER = Logging.getLogger(CompatibilityRules.class);

    public void apply(Project project) {
        project.getDependencies().attributesSchema(schema -> {
            schema.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, matchingStrategy -> {
                matchingStrategy.getCompatibilityRules().add(LibraryElementCompatibilityRules.class);
                matchingStrategy.getDisambiguationRules().add(LibraryElementDisambiguationRules.class);
            });
            schema.attribute(CppBinary.LINKAGE_ATTRIBUTE, matchingStrategy -> matchingStrategy.getDisambiguationRules().pickFirst((Comparator)new Comparator<Linkage>(){

                @Override
                public int compare(Linkage lhs, Linkage rhs) {
                    LOGGER.debug("Disambiguation for linkage (" + lhs.getName() + " =?= " + rhs.getName() + ")");
                    if (lhs.equals((Object)Linkage.SHARED) && rhs.equals((Object)Linkage.SHARED)) {
                        return 0;
                    }
                    if (lhs.equals((Object)Linkage.SHARED)) {
                        return -1;
                    }
                    if (rhs.equals((Object)Linkage.SHARED)) {
                        return 1;
                    }
                    return 0;
                }
            }));
            schema.attribute(CppBinary.OPTIMIZED_ATTRIBUTE, matchingStrategy -> matchingStrategy.getDisambiguationRules().add(OptimizationSelectionRule.class));
        });
    }

    public static class LibraryElementDisambiguationRules
    implements AttributeDisambiguationRule<LibraryElements> {
        public void execute(MultipleCandidatesDetails<LibraryElements> details) {
            Map<String, LibraryElements> candidates = details.getCandidateValues().stream().map(it -> new AbstractMap.SimpleEntry<String, LibraryElements>(it.getName(), (LibraryElements)it)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (details.getConsumerValue() == null) {
                LOGGER.debug("no consumer value");
            }
            if (candidates.containsKey("framework-bundle")) {
                LOGGER.debug("Pick framework " + candidates.get("framework-bundle").getName());
                details.closestMatch((Object)candidates.get("framework"));
            } else if (candidates.containsKey("dynamic-lib")) {
                LOGGER.debug("Pick dynamic library " + candidates.get("dynamic-lib").getName());
                details.closestMatch((Object)candidates.get("dynamic-lib"));
            } else {
                LOGGER.debug("Not sure why there is an ambiguation");
            }
        }
    }

    public static class LibraryElementCompatibilityRules
    implements AttributeCompatibilityRule<LibraryElements> {
        public void execute(CompatibilityCheckDetails<LibraryElements> details) {
            if (((LibraryElements)details.getProducerValue()).getName().startsWith("something-to-")) {
                details.incompatible();
            } else {
                details.compatible();
            }
        }
    }

    public static class OptimizationSelectionRule
    implements AttributeDisambiguationRule<Boolean> {
        public void execute(MultipleCandidatesDetails<Boolean> details) {
            LOGGER.debug("Disambiguating 'org.gradle.native.optimized' requesting '" + details.getConsumerValue() + "' for values '" + details.getCandidateValues().stream().map(Object::toString).collect(Collectors.joining(", ")) + "'");
            if (details.getCandidateValues().contains(Boolean.FALSE)) {
                details.closestMatch((Object)Boolean.FALSE);
            }
        }
    }
}

