/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.ios.tasks.internal;

import dev.nokee.core.exec.CommandLineTool;
import dev.nokee.core.exec.CommandLineToolExecutionEngine;
import dev.nokee.core.exec.GradleWorkerExecutorEngine;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;

public abstract class StoryboardLinkTask
extends DefaultTask {
    @OutputDirectory
    public abstract DirectoryProperty getDestinationDirectory();

    @Input
    public abstract Property<String> getModule();

    @SkipWhenEmpty
    @InputFiles
    protected List<File> getInputFiles() {
        return this.getSources().getFiles().stream().flatMap(it -> {
            File[] files = it.listFiles();
            if (files == null) {
                return Stream.empty();
            }
            return Arrays.stream(files);
        }).collect(Collectors.toList());
    }

    @Internal
    public abstract ConfigurableFileCollection getSources();

    @Nested
    public abstract Property<CommandLineTool> getInterfaceBuilderTool();

    public StoryboardLinkTask() {
        this.dependsOn(new Object[]{this.getSources()});
    }

    @Inject
    protected abstract ObjectFactory getObjects();

    @TaskAction
    private void doLink() {
        ((CommandLineTool)this.getInterfaceBuilderTool().get()).withArguments(new Object[]{"--errors", "--warnings", "--notices", "--module", this.getModule().get(), "--auto-activate-custom-fonts", "--target-device", "iphone", "--target-device", "ipad", "--minimum-deployment-target", "13.2", "--output-format", "human-readable-text", "--link", ((Directory)this.getDestinationDirectory().get()).getAsFile().getAbsolutePath(), this.getInputFiles().stream().map(File::getAbsolutePath).collect(Collectors.joining(" "))}).newInvocation().appendStandardStreamToFile(new File(this.getTemporaryDir(), "outputs.txt")).buildAndSubmit((CommandLineToolExecutionEngine)this.getObjects().newInstance(GradleWorkerExecutorEngine.class, new Object[0]));
    }
}

