/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.ios.tasks.internal;

import dev.nokee.core.exec.CommandLineTool;
import dev.nokee.core.exec.CommandLineToolExecutionEngine;
import dev.nokee.core.exec.GradleWorkerExecutorEngine;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileType;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;

@CacheableTask
public abstract class StoryboardCompileTask
extends DefaultTask {
    @OutputDirectory
    public abstract DirectoryProperty getDestinationDirectory();

    @Input
    public abstract Property<String> getModule();

    @Incremental
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getSources();

    @Nested
    public abstract Property<CommandLineTool> getInterfaceBuilderTool();

    @Inject
    protected abstract ObjectFactory getObjects();

    @TaskAction
    private void compile(InputChanges inputChanges) throws IOException {
        new File(this.getTemporaryDir(), "outputs.txt").delete();
        if (inputChanges.isIncremental()) {
            for (FileChange it : inputChanges.getFileChanges((FileCollection)this.getSources())) {
                if (it.getChangeType().equals((Object)ChangeType.REMOVED)) {
                    if (it.getFileType().equals((Object)FileType.FILE)) {
                        FileUtils.deleteDirectory((File)new File(((Directory)this.getDestinationDirectory().get()).getAsFile().getAbsolutePath() + "/" + it.getFile().getParentFile().getName() + "/" + it.getFile().getName() + "c"));
                        continue;
                    }
                    if (!it.getFileType().equals((Object)FileType.DIRECTORY)) continue;
                    FileUtils.deleteDirectory((File)new File(((Directory)this.getDestinationDirectory().get()).getAsFile().getAbsolutePath() + "/" + it.getFile().getName()));
                    continue;
                }
                this.build(it.getFile());
            }
        } else {
            if (this.getSources().getAsFileTree().isEmpty()) {
                this.getState().setDidWork(false);
                this.getState().setOutcome(TaskExecutionOutcome.NO_SOURCE);
                return;
            }
            for (File source : this.getSources()) {
                this.build(source);
            }
        }
    }

    private void build(File source) {
        ((CommandLineTool)this.getInterfaceBuilderTool().get()).withArguments(new Object[]{"--errors", "--warnings", "--notices", "--module", this.getModule().get(), "--output-partial-info-plist", this.getTemporaryDir().getAbsolutePath() + "/" + FilenameUtils.removeExtension((String)source.getName()) + "-SBPartialInfo.plist", "--auto-activate-custom-fonts", "--target-device", "iphone", "--target-device", "ipad", "--minimum-deployment-target", "13.2", "--output-format", "human-readable-text", "--compilation-directory", ((Directory)this.getDestinationDirectory().get()).getAsFile().getAbsolutePath() + "/" + source.getParentFile().getName(), source.getAbsolutePath()}).newInvocation().appendStandardStreamToFile(new File(this.getTemporaryDir(), "outputs.txt")).buildAndSubmit((CommandLineToolExecutionEngine)this.getObjects().newInstance(GradleWorkerExecutorEngine.class, new Object[0]));
    }
}

