/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.ios.tasks.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;

public abstract class ProcessPropertyListTask
extends DefaultTask {
    @Optional
    @SkipWhenEmpty
    @InputFiles
    public abstract ConfigurableFileCollection getSources();

    @Input
    public abstract Property<String> getModule();

    @Input
    public abstract Property<String> getIdentifier();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @Inject
    protected abstract ExecOperations getExecOperations();

    @TaskAction
    private void process() throws IOException {
        File xmlPlist = new File(this.getTemporaryDir(), "Info.plist");
        xmlPlist.delete();
        this.getExecOperations().exec(spec -> {
            spec.executable((Object)this.getPlistBuddyExecutable().getAbsolutePath());
            for (File source : this.getSources()) {
                spec.args(new Object[]{"-c", "Merge \"" + source.getAbsolutePath() + "\""});
            }
            spec.args(new Object[]{"-c", "Save"});
            spec.args(new Object[]{xmlPlist.getAbsolutePath()});
            try {
                spec.setStandardOutput((OutputStream)new FileOutputStream(new File(this.getTemporaryDir(), "outputs.txt")));
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException(e);
            }
        });
        this.getExecOperations().exec(spec -> {
            spec.executable((Object)this.getPlistBuddyExecutable().getAbsolutePath());
            spec.args(new Object[]{"-c", "Add :DTSDKName string iphonesimulator13.2"});
            spec.args(new Object[]{"-c", "Add :DTXcode string 1130"});
            spec.args(new Object[]{"-c", "Add :DTSDKBuild string 17B102"});
            spec.args(new Object[]{"-c", "Add :BuildMachineOSBuild string 19D76"});
            spec.args(new Object[]{"-c", "Add :DTPlatformName string iphonesimulator"});
            spec.args(new Object[]{"-c", "Add :CFBundleSupportedPlatforms array"});
            spec.args(new Object[]{"-c", "Add :CFBundleSupportedPlatforms:0 string iPhoneSimulator"});
            spec.args(new Object[]{"-c", "Add :DTCompiler string com.apple.compilers.llvm.clang.1_0"});
            spec.args(new Object[]{"-c", "Save"});
            spec.args(new Object[]{xmlPlist.getAbsolutePath()});
            try {
                spec.setStandardOutput((OutputStream)new FileOutputStream(new File(this.getTemporaryDir(), "outputs.txt"), true));
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException(e);
            }
        });
        this.getExecOperations().exec(spec -> {
            spec.executable((Object)this.getPlistBuddyExecutable().getAbsolutePath());
            spec.args(new Object[]{"-c", "Add :MinimumOSVersion string 13.2"});
            spec.args(new Object[]{"-c", "Add :DTPlatformVersion string 13.2"});
            spec.args(new Object[]{"-c", "Add :UIDeviceFamily array"});
            spec.args(new Object[]{"-c", "Add :UIDeviceFamily:0 integer 1"});
            spec.args(new Object[]{"-c", "Add :UIDeviceFamily:1 integer 2"});
            spec.args(new Object[]{"-c", "Add :DTXcodeBuild string 11C504"});
            spec.args(new Object[]{"-c", "Add :DTPlatformBuild string"});
            spec.args(new Object[]{"-c", "Save"});
            spec.args(new Object[]{xmlPlist.getAbsolutePath()});
            try {
                spec.setStandardOutput((OutputStream)new FileOutputStream(new File(this.getTemporaryDir(), "outputs.txt"), true));
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException(e);
            }
        });
        String data = FileUtils.readFileToString((File)xmlPlist, (Charset)Charset.defaultCharset()).replace("$(PRODUCT_NAME)", (CharSequence)this.getModule().get()).replace("$(EXECUTABLE_NAME)", (CharSequence)this.getModule().get()).replace("$(PRODUCT_BUNDLE_IDENTIFIER)", (CharSequence)this.getIdentifier().get()).replace("$(DEVELOPMENT_LANGUAGE)", "en").replace("$(PRODUCT_BUNDLE_PACKAGE_TYPE)", "APPL").replace("$(PRODUCT_MODULE_NAME)", (CharSequence)this.getModule().get());
        FileUtils.write((File)xmlPlist, (CharSequence)data, (Charset)Charset.defaultCharset());
        this.getExecOperations().exec(spec -> {
            spec.executable((Object)this.getPlutilExecutable().getAbsolutePath());
            spec.args(new Object[]{"-convert", "binary1", "-o", ((RegularFile)this.getOutputFile().get()).getAsFile().getAbsolutePath(), xmlPlist.getAbsolutePath()});
            try {
                spec.setStandardOutput((OutputStream)new FileOutputStream(new File(this.getTemporaryDir(), "outputs.txt"), true));
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    @InputFile
    protected File getPlistBuddyExecutable() {
        return new File("/usr/libexec/PlistBuddy");
    }

    @InputFile
    protected File getPlutilExecutable() {
        return new File(ProcessPropertyListTask.getPlutilPath());
    }

    private static String getPlutilPath() {
        try {
            Process process = new ProcessBuilder("xcrun", "--sdk", "iphonesimulator", "--find", "plutil").start();
            process.waitFor();
            return IOUtils.toString((InputStream)process.getInputStream(), (Charset)Charset.defaultCharset()).trim();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

