/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.ios.tasks.internal;

import dev.nokee.core.exec.CommandLine;
import dev.nokee.core.exec.CommandLineToolExecutionEngine;
import dev.nokee.core.exec.ProcessBuilderEngine;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;

public abstract class CreateIosApplicationBundleTask
extends DefaultTask {
    @OutputDirectory
    public abstract Property<FileSystemLocation> getApplicationBundle();

    @Internal
    public abstract RegularFileProperty getExecutable();

    @Input
    public abstract Property<Boolean> getSwiftSupportRequired();

    @Internal
    public abstract ConfigurableFileCollection getSources();

    @SkipWhenEmpty
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    protected FileTree getInputFiles() {
        return this.getSources().getAsFileTree();
    }

    @InputFiles
    public abstract ConfigurableFileCollection getPlugIns();

    @InputFiles
    public abstract ConfigurableFileCollection getFrameworks();

    @Inject
    protected abstract FileSystemOperations getFileOperations();

    @Inject
    protected abstract ExecOperations getExecOperations();

    @TaskAction
    private void create() throws IOException {
        this.getFileOperations().sync(spec -> {
            spec.from(new Object[]{this.getSources().getFiles()});
            for (File file : this.getFrameworks().getFiles()) {
                if (file.isDirectory()) {
                    spec.from((Object)file, it -> it.into((Object)("Frameworks/" + file.getName())));
                    continue;
                }
                spec.from((Object)file, it -> it.into((Object)"Frameworks"));
            }
            for (File file : this.getPlugIns().getFiles()) {
                if (file.isDirectory()) {
                    spec.from((Object)file, it -> it.into((Object)("PlugIns/" + file.getName())));
                    continue;
                }
                spec.from((Object)file, it -> it.into((Object)"PlugIns"));
            }
            spec.into(this.getApplicationBundle());
        });
        FileUtils.write((File)new File(((FileSystemLocation)this.getApplicationBundle().get()).getAsFile(), "PkgInfo"), (CharSequence)"APPL????", (Charset)Charset.defaultCharset());
        if (((Boolean)this.getSwiftSupportRequired().get()).booleanValue()) {
            this.getExecOperations().exec(spec -> {
                File bundleFile = ((RegularFile)this.getExecutable().get()).getAsFile();
                File bundleDir = ((FileSystemLocation)this.getApplicationBundle().get()).getAsFile();
                spec.executable((Object)CreateIosApplicationBundleTask.getSwiftStdlibTool());
                spec.args(new Object[]{"--copy", "--scan-executable", bundleFile.getAbsolutePath(), "--destination", new File(bundleDir, "Frameworks").getAbsolutePath(), "--platform", "iphonesimulator", "--scan-folder", new File(bundleDir, "Frameworks").getAbsolutePath()});
            });
        }
    }

    private static String getSwiftStdlibTool() {
        return ((ProcessBuilderEngine.Handle)CommandLine.of((Object[])new Object[]{"xcrun", "--sdk", "iphonesimulator", "--find", "swift-stdlib-tool"}).execute((CommandLineToolExecutionEngine)new ProcessBuilderEngine())).waitFor().assertNormalExitValue().getStandardOutput().getAsString().trim();
    }
}

