/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.ios.internal.plugins;

import dev.nokee.internal.Cast;
import dev.nokee.platform.base.internal.ComponentCollection;
import dev.nokee.platform.base.internal.GroupId;
import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.ios.SwiftIosApplicationExtension;
import dev.nokee.platform.ios.internal.DefaultIosApplicationComponent;
import dev.nokee.platform.ios.internal.DefaultSwiftIosApplicationExtension;
import dev.nokee.platform.ios.tasks.internal.CreateIosApplicationBundleTask;
import dev.nokee.runtime.darwin.internal.plugins.DarwinRuntimePlugin;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.nativeplatform.toolchain.plugins.SwiftCompilerPlugin;

public abstract class SwiftIosApplicationPlugin
implements Plugin<Project> {
    private static final String EXTENSION_NAME = "application";

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract TaskContainer getTasks();

    public void apply(Project project) {
        project.getPluginManager().apply(SwiftCompilerPlugin.class);
        project.getPluginManager().apply(DarwinRuntimePlugin.class);
        NamingScheme names = NamingScheme.asMainComponent((String)project.getName()).withComponentDisplayName("main iOS application");
        ComponentCollection components = (ComponentCollection)Cast.uncheckedCast((String)"of type erasure", (Object)project.getExtensions().create("components", ComponentCollection.class, new Object[0]));
        DefaultIosApplicationComponent component = (DefaultIosApplicationComponent)components.register(DefaultIosApplicationComponent.class, names).get();
        component.getGroupId().set((Object)GroupId.of(() -> ((Project)project).getGroup()));
        DefaultSwiftIosApplicationExtension extension = (DefaultSwiftIosApplicationExtension)this.getObjects().newInstance(DefaultSwiftIosApplicationExtension.class, new Object[]{component});
        project.afterEvaluate(extension::finalizeExtension);
        project.getExtensions().add(SwiftIosApplicationExtension.class, EXTENSION_NAME, (Object)extension);
        this.getTasks().withType(CreateIosApplicationBundleTask.class).configureEach(task -> task.getSwiftSupportRequired().set((Object)true));
    }
}

