/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.ios.internal.plugins;

import dev.nokee.internal.Cast;
import dev.nokee.platform.base.internal.ComponentCollection;
import dev.nokee.platform.base.internal.GroupId;
import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.ios.ObjectiveCIosApplicationExtension;
import dev.nokee.platform.ios.internal.DefaultIosApplicationComponent;
import dev.nokee.platform.ios.internal.DefaultObjectiveCIosApplicationExtension;
import dev.nokee.platform.ios.internal.plugins.IosApplicationRules;
import dev.nokee.platform.nativebase.internal.NativePlatformFactory;
import dev.nokee.runtime.darwin.internal.plugins.DarwinRuntimePlugin;
import dev.nokee.runtime.nativebase.MachineArchitecture;
import dev.nokee.runtime.nativebase.OperatingSystemFamily;
import dev.nokee.runtime.nativebase.internal.DefaultMachineArchitecture;
import dev.nokee.runtime.nativebase.internal.DefaultOperatingSystemFamily;
import java.util.Arrays;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.nativeplatform.toolchain.Clang;
import org.gradle.nativeplatform.toolchain.NativeToolChainRegistry;
import org.gradle.nativeplatform.toolchain.internal.gcc.DefaultGccPlatformToolChain;
import org.gradle.nativeplatform.toolchain.internal.plugins.StandardToolChainsPlugin;

public abstract class ObjectiveCIosApplicationPlugin
implements Plugin<Project> {
    private static final String EXTENSION_NAME = "application";

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProjectLayout getLayout();

    @Inject
    protected abstract TaskContainer getTasks();

    @Inject
    protected abstract ProviderFactory getProviders();

    public void apply(Project project) {
        project.getPluginManager().apply(StandardToolChainsPlugin.class);
        project.getPluginManager().apply(ToolChainMetadataRules.class);
        project.getPluginManager().apply(DarwinRuntimePlugin.class);
        NamingScheme names = NamingScheme.asMainComponent((String)project.getName()).withComponentDisplayName("main iOS application");
        ComponentCollection components = (ComponentCollection)Cast.uncheckedCast((String)"of type erasure", (Object)project.getExtensions().create("components", ComponentCollection.class, new Object[0]));
        DefaultIosApplicationComponent component = (DefaultIosApplicationComponent)components.register(DefaultIosApplicationComponent.class, names).get();
        component.getGroupId().set((Object)GroupId.of(() -> ((Project)project).getGroup()));
        DefaultObjectiveCIosApplicationExtension extension = (DefaultObjectiveCIosApplicationExtension)this.getObjects().newInstance(DefaultObjectiveCIosApplicationExtension.class, new Object[]{component});
        project.afterEvaluate(extension::finalizeExtension);
        project.getExtensions().add(ObjectiveCIosApplicationExtension.class, EXTENSION_NAME, (Object)extension);
    }

    public static class ToolChainMetadataRules
    extends RuleSource {
        @Mutate
        public void configureToolchain(NativeToolChainRegistry toolchains) {
            toolchains.withType(Clang.class, toolchain -> toolchain.target(NativePlatformFactory.platformNameFor((OperatingSystemFamily)DefaultOperatingSystemFamily.IOS, (MachineArchitecture)DefaultMachineArchitecture.X86_64), platform -> {
                ((DefaultGccPlatformToolChain)platform).getCompilerProbeArgs().clear();
                ((DefaultGccPlatformToolChain)platform).getCompilerProbeArgs().addAll(Arrays.asList("-target", "x86_64-apple-ios13.2-simulator", "-isysroot", IosApplicationRules.getSdkPath()));
            }));
        }
    }
}

