/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.platform.ios.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dev.nokee.core.exec.internal.PathAwareCommandLineTool;
import dev.nokee.core.exec.internal.VersionedCommandLineTool;
import dev.nokee.language.base.tasks.SourceCompile;
import dev.nokee.language.objectivec.tasks.ObjectiveCCompile;
import dev.nokee.language.swift.internal.SwiftSourceSet;
import dev.nokee.platform.base.Binary;
import dev.nokee.platform.base.BinaryAwareComponent;
import dev.nokee.platform.base.DependencyAwareComponent;
import dev.nokee.platform.base.internal.BuildVariant;
import dev.nokee.platform.base.internal.Component;
import dev.nokee.platform.base.internal.GroupId;
import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.base.internal.VariantProvider;
import dev.nokee.platform.ios.internal.DefaultIosApplicationVariant;
import dev.nokee.platform.ios.internal.DescriptorCommandLineTool;
import dev.nokee.platform.ios.internal.IosApplicationBundleInternal;
import dev.nokee.platform.ios.internal.IosApplicationOutgoingDependencies;
import dev.nokee.platform.ios.internal.SignedIosApplicationBundleInternal;
import dev.nokee.platform.ios.internal.plugins.IosApplicationRules;
import dev.nokee.platform.ios.tasks.internal.AssetCatalogCompileTask;
import dev.nokee.platform.ios.tasks.internal.CreateIosApplicationBundleTask;
import dev.nokee.platform.ios.tasks.internal.ProcessPropertyListTask;
import dev.nokee.platform.ios.tasks.internal.SignIosApplicationBundleTask;
import dev.nokee.platform.ios.tasks.internal.StoryboardCompileTask;
import dev.nokee.platform.ios.tasks.internal.StoryboardLinkTask;
import dev.nokee.platform.nativebase.ExecutableBinary;
import dev.nokee.platform.nativebase.NativeComponentDependencies;
import dev.nokee.platform.nativebase.internal.BaseNativeBinary;
import dev.nokee.platform.nativebase.internal.BaseNativeComponent;
import dev.nokee.platform.nativebase.internal.BaseNativeVariant;
import dev.nokee.platform.nativebase.internal.DefaultBinaryLinkage;
import dev.nokee.platform.nativebase.internal.ExecutableBinaryInternal;
import dev.nokee.platform.nativebase.internal.dependencies.AbstractBinaryAwareNativeComponentDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.BinaryAwareNativeComponentDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.DefaultHeaderIncomingDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.DefaultNativeComponentDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.DefaultSwiftModuleIncomingDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.HeaderIncomingDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.NativeIncomingDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.NativeOutgoingDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.NoHeaderIncomingDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.NoSwiftModuleIncomingDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.SwiftModuleIncomingDependencies;
import dev.nokee.platform.nativebase.tasks.LinkExecutable;
import dev.nokee.runtime.nativebase.internal.DefaultMachineArchitecture;
import dev.nokee.runtime.nativebase.internal.DefaultOperatingSystemFamily;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.nativeplatform.toolchain.Swiftc;
import org.gradle.util.GUtil;
import org.gradle.util.VersionNumber;

public abstract class DefaultIosApplicationComponent
extends BaseNativeComponent<DefaultIosApplicationVariant>
implements DependencyAwareComponent<NativeComponentDependencies>,
BinaryAwareComponent,
Component {
    private final DefaultNativeComponentDependencies dependencies;

    @Inject
    public DefaultIosApplicationComponent(NamingScheme names) {
        super(names, DefaultIosApplicationVariant.class);
        this.dependencies = (DefaultNativeComponentDependencies)this.getObjects().newInstance(DefaultNativeComponentDependencies.class, new Object[]{names});
        this.getDimensions().convention((Iterable)ImmutableSet.of((Object)DefaultOperatingSystemFamily.DIMENSION_TYPE, (Object)DefaultMachineArchitecture.DIMENSION_TYPE, (Object)DefaultBinaryLinkage.DIMENSION_TYPE));
    }

    public abstract Property<GroupId> getGroupId();

    public DefaultNativeComponentDependencies getDependencies() {
        return this.dependencies;
    }

    public void dependencies(Action<? super NativeComponentDependencies> action) {
        action.execute((Object)this.dependencies);
    }

    protected Provider<DefaultIosApplicationVariant> getDefaultVariant() {
        return this.getProviders().provider(() -> {
            List variants = this.getVariants().get().stream().map(it -> {
                Preconditions.checkArgument((boolean)(it instanceof BaseNativeVariant));
                return it;
            }).collect(Collectors.toList());
            if (variants.isEmpty()) {
                return null;
            }
            return (DefaultIosApplicationVariant)DefaultIosApplicationComponent.one(variants);
        });
    }

    protected DefaultIosApplicationVariant createVariant(String name, BuildVariant buildVariant, AbstractBinaryAwareNativeComponentDependencies variantDependencies) {
        NamingScheme names = this.getNames().forBuildVariant(buildVariant, (Collection)this.getBuildVariants().get());
        DefaultIosApplicationVariant result = (DefaultIosApplicationVariant)this.getObjects().newInstance(DefaultIosApplicationVariant.class, new Object[]{name, names, buildVariant, variantDependencies});
        return result;
    }

    protected AbstractBinaryAwareNativeComponentDependencies newDependencies(NamingScheme names, BuildVariant buildVariant) {
        boolean hasSwift;
        DefaultNativeComponentDependencies variantDependencies = this.getDependencies();
        if (((Set)this.getBuildVariants().get()).size() > 1) {
            variantDependencies = variantDependencies.extendsWith(names);
        }
        SwiftModuleIncomingDependencies incomingSwiftDependencies = null;
        HeaderIncomingDependencies incomingHeaderDependencies = null;
        boolean bl = hasSwift = !this.getSourceCollection().withType(SwiftSourceSet.class).isEmpty();
        if (hasSwift) {
            incomingSwiftDependencies = (SwiftModuleIncomingDependencies)this.getObjects().newInstance(DefaultSwiftModuleIncomingDependencies.class, new Object[]{names, variantDependencies});
            incomingHeaderDependencies = (HeaderIncomingDependencies)this.getObjects().newInstance(NoHeaderIncomingDependencies.class, new Object[0]);
        } else {
            incomingHeaderDependencies = (HeaderIncomingDependencies)this.getObjects().newInstance(DefaultHeaderIncomingDependencies.class, new Object[]{names, variantDependencies, buildVariant});
            incomingSwiftDependencies = (SwiftModuleIncomingDependencies)this.getObjects().newInstance(NoSwiftModuleIncomingDependencies.class, new Object[0]);
        }
        NativeIncomingDependencies incoming = (NativeIncomingDependencies)this.getObjects().newInstance(NativeIncomingDependencies.class, new Object[]{names, buildVariant, variantDependencies, incomingSwiftDependencies, incomingHeaderDependencies});
        NativeOutgoingDependencies outgoing = (NativeOutgoingDependencies)this.getObjects().newInstance(IosApplicationOutgoingDependencies.class, new Object[]{names, buildVariant, variantDependencies});
        return (AbstractBinaryAwareNativeComponentDependencies)this.getObjects().newInstance(BinaryAwareNativeComponentDependencies.class, new Object[]{variantDependencies, incoming, outgoing});
    }

    @Inject
    protected abstract DependencyHandler getDependencyHandler();

    protected void onEachVariant(BuildVariant buildVariant, VariantProvider<DefaultIosApplicationVariant> variant, NamingScheme names) {
        variant.configure(application -> {
            application.getBinaries().configureEach(ExecutableBinary.class, binary -> {
                binary.getCompileTasks().configureEach(SourceCompile.class, task -> {
                    task.getCompilerArgs().addAll(this.getProviders().provider(() -> ImmutableList.of((Object)"-target", (Object)"x86_64-apple-ios13.2-simulator", (Object)"-F", (Object)(IosApplicationRules.getSdkPath() + "/System/Library/Frameworks"))));
                    task.getCompilerArgs().addAll(task.getToolChain().map(toolChain -> {
                        if (toolChain instanceof Swiftc) {
                            return ImmutableList.of((Object)"-sdk", (Object)IosApplicationRules.getSdkPath());
                        }
                        return ImmutableList.of((Object)"-isysroot", (Object)IosApplicationRules.getSdkPath());
                    }));
                    if (task instanceof ObjectiveCCompile) {
                        task.getCompilerArgs().addAll((Object[])new String[]{"-fobjc-arc"});
                    }
                });
                binary.getLinkTask().configure(task -> {
                    task.getLinkerArgs().addAll(this.getProviders().provider(() -> ImmutableList.of((Object)"-target", (Object)"x86_64-apple-ios13.2-simulator")));
                    task.getLinkerArgs().addAll(task.getToolChain().map(toolChain -> {
                        if (toolChain instanceof Swiftc) {
                            return ImmutableList.of((Object)"-sdk", (Object)IosApplicationRules.getSdkPath());
                        }
                        return ImmutableList.of((Object)"-isysroot", (Object)IosApplicationRules.getSdkPath());
                    }));
                    task.getLinkerArgs().addAll((Object[])new String[]{"-Xlinker", "-rpath", "-Xlinker", "@executable_path/Frameworks", "-Xlinker", "-export_dynamic", "-Xlinker", "-no_deduplicate", "-Xlinker", "-objc_abi_version", "-Xlinker", "2", "-lobjc", "-framework", "UIKit", "-framework", "Foundation"});
                });
            });
            Configuration interfaceBuilderToolConfiguration = (Configuration)this.getConfigurations().create("interfaceBuilderTool");
            interfaceBuilderToolConfiguration.getDependencies().add((Object)this.getDependencyHandler().create((Object)"dev.nokee.tool:ibtool:latest.release"));
            Provider interfaceBuilderTool = this.getProviders().provider(() -> new DescriptorCommandLineTool(interfaceBuilderToolConfiguration.getSingleFile()));
            Provider assetCompilerTool = this.getProviders().provider(() -> new VersionedCommandLineTool(new File("/usr/bin/actool"), VersionNumber.parse((String)"11.3.1")));
            Provider codeSignatureTool = this.getProviders().provider(() -> new PathAwareCommandLineTool(new File("/usr/bin/codesign")));
            String moduleName = names.getBaseName().getAsCamelCase();
            Provider identifier = this.getProviders().provider(() -> ((GroupId)this.getGroupId().get()).get().map(it -> it + "." + moduleName).orElse(moduleName));
            TaskProvider compileStoryboardTask = this.getTasks().register("compileStoryboard", StoryboardCompileTask.class, task -> {
                task.getDestinationDirectory().set(this.getLayout().getBuildDirectory().dir("ios/storyboards/compiled/main"));
                task.getModule().set((Object)moduleName);
                task.getSources().from(new Object[]{this.getObjects().fileTree().setDir((Object)"src/main/resources").matching(it -> it.include(new String[]{"*.lproj/*.storyboard"}))});
                task.getInterfaceBuilderTool().set(interfaceBuilderTool);
                task.getInterfaceBuilderTool().finalizeValueOnRead();
            });
            TaskProvider linkStoryboardTask = this.getTasks().register("linkStoryboard", StoryboardLinkTask.class, task -> {
                task.getDestinationDirectory().set(this.getLayout().getBuildDirectory().dir("ios/storyboards/linked/main"));
                task.getModule().set((Object)moduleName);
                task.getSources().from(new Object[]{compileStoryboardTask.flatMap(StoryboardCompileTask::getDestinationDirectory)});
                task.getInterfaceBuilderTool().set(interfaceBuilderTool);
                task.getInterfaceBuilderTool().finalizeValueOnRead();
            });
            TaskProvider assetCatalogCompileTaskTask = this.getTasks().register("compileAssetCatalog", AssetCatalogCompileTask.class, task -> {
                task.getSource().set((Object)this.getLayout().getProjectDirectory().file("src/main/resources/Assets.xcassets"));
                task.getIdentifier().set(identifier);
                task.getDestinationDirectory().set(this.getLayout().getBuildDirectory().dir("ios/assets/main"));
                task.getAssetCompilerTool().set(assetCompilerTool);
            });
            TaskProvider processPropertyListTask = this.getTasks().register("processPropertyList", ProcessPropertyListTask.class, task -> {
                task.getIdentifier().set(identifier);
                task.getModule().set((Object)moduleName);
                task.getSources().from(new Object[]{this.getProviders().provider(() -> {
                    File plistFile = this.getLayout().getProjectDirectory().file("src/main/resources/Info.plist").getAsFile();
                    if (plistFile.exists()) {
                        return ImmutableList.of((Object)plistFile);
                    }
                    return ImmutableList.of();
                })});
                task.getOutputFile().set(this.getLayout().getBuildDirectory().file("ios/Info.plist"));
            });
            TaskProvider createApplicationBundleTask = this.getTasks().register("createApplicationBundle", CreateIosApplicationBundleTask.class, task -> {
                List binaries = (List)application.getBinaries().withType(ExecutableBinaryInternal.class).map(it -> it.getLinkTask().flatMap(LinkExecutable::getLinkedFile)).get();
                task.getExecutable().set((Provider)binaries.iterator().next());
                task.getSwiftSupportRequired().convention((Object)false);
                task.getApplicationBundle().set(this.getLayout().getBuildDirectory().file("ios/products/main/" + moduleName + "-unsigned.app"));
                task.getSources().from(new Object[]{linkStoryboardTask.flatMap(StoryboardLinkTask::getDestinationDirectory)});
                task.getSources().from(new Object[]{binaries});
                task.getSources().from(new Object[]{assetCatalogCompileTaskTask.flatMap(AssetCatalogCompileTask::getDestinationDirectory)});
                task.getSources().from(new Object[]{processPropertyListTask.flatMap(ProcessPropertyListTask::getOutputFile)});
            });
            application.getBinaryCollection().add((Object)((Binary)this.getObjects().newInstance(IosApplicationBundleInternal.class, new Object[0])));
            TaskProvider signApplicationBundleTask = this.getTasks().register("signApplicationBundle", SignIosApplicationBundleTask.class, task -> {
                task.getUnsignedApplicationBundle().set(createApplicationBundleTask.flatMap(CreateIosApplicationBundleTask::getApplicationBundle));
                task.getSignedApplicationBundle().set(this.getLayout().getBuildDirectory().file("ios/products/main/" + moduleName + ".app"));
                task.getCodeSignatureTool().set(codeSignatureTool);
            });
            application.getBinaryCollection().add((Object)((Binary)this.getObjects().newInstance(SignedIosApplicationBundleInternal.class, new Object[]{signApplicationBundleTask})));
        });
        TaskProvider bundle = this.getTasks().register("bundle", task -> task.dependsOn(new Object[]{variant.map(it -> it.getBinaries().withType(SignedIosApplicationBundleInternal.class).get())}));
    }

    public void finalizeExtension(Project project) {
        this.getVariants().configureEach(variant -> variant.getBinaries().configureEach(BaseNativeBinary.class, binary -> binary.getBaseName().convention((Object)GUtil.toCamelCase((CharSequence)project.getName()))));
        super.finalizeExtension(project);
    }
}

