/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.fixtures.tasks;

import dev.nokee.fixtures.tasks.WellBehavingTaskAssertion;
import dev.nokee.fixtures.tasks.WellBehavingTaskProperty;
import dev.nokee.fixtures.tasks.WellBehavingTaskPropertyMutator;
import dev.nokee.fixtures.tasks.WellBehavingTaskPropertyValue;
import dev.nokee.fixtures.tasks.WellBehavingTaskSpec;
import dev.nokee.fixtures.tasks.WellBehavingTaskTestCase;
import dev.nokee.fixtures.tasks.WellBehavingTaskTestSuite;
import dev.nokee.fixtures.tasks.WellBehavingTaskTransform;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.gradle.api.Task;

public class WellBehavingTaskPropertyBuilder {
    @NonNull
    private final String propertyName;
    @NonNull
    private final Class<? extends Task> taskType;
    private final List<WellBehavingTaskTestCase> upToDateChecks = new ArrayList<WellBehavingTaskTestCase>();
    private final List<WellBehavingTaskTestCase> cacheableChecks = new ArrayList<WellBehavingTaskTestCase>();
    private final List<WellBehavingTaskTestCase> incrementalChecks = new ArrayList<WellBehavingTaskTestCase>();
    private WellBehavingTaskPropertyValue initialValue = null;
    private WellBehavingTaskPropertyMutator mutator = null;

    public WellBehavingTaskPropertyBuilder(String propertyName, Class<? extends Task> taskType) {
        this.propertyName = propertyName;
        this.taskType = taskType;
    }

    public WellBehavingTaskPropertyBuilder withInitialValue(@NonNull WellBehavingTaskPropertyValue value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        assert (this.initialValue == null) : "initial value already configured";
        this.initialValue = value;
        return this;
    }

    public WellBehavingTaskPropertyBuilder withInitialValue(@NonNull String initialValue) {
        if (initialValue == null) {
            throw new NullPointerException("initialValue is marked non-null but is null");
        }
        return this.withInitialValue(WellBehavingTaskPropertyValue.Quoted.of(initialValue));
    }

    public WellBehavingTaskPropertyBuilder outOfDateWhen(@NonNull WellBehavingTaskTransform transform) {
        if (transform == null) {
            throw new NullPointerException("transform is marked non-null but is null");
        }
        this.upToDateChecks.add(new WellBehavingTaskTestCase(this.propertyName, transform, WellBehavingTaskSpec.taskUnderTestExecutedAndNotSkipped().and(WellBehavingTaskSpec::assertInitialState)));
        return this;
    }

    public WellBehavingTaskPropertyBuilder configureAsProperty() {
        this.mutator = new WellBehavingTaskPropertyMutator.Property(this.propertyName);
        return this;
    }

    public WellBehavingTaskPropertyBuilder configureAsFileCollection() {
        this.mutator = new WellBehavingTaskPropertyMutator.FileCollection(this.propertyName);
        return this;
    }

    public WellBehavingTaskPropertyBuilder restoreFromCacheWhen(@NonNull WellBehavingTaskTransform transform) {
        if (transform == null) {
            throw new NullPointerException("transform is marked non-null but is null");
        }
        this.cacheableChecks.add(new WellBehavingTaskTestCase(this.propertyName, transform, WellBehavingTaskSpec.taskUnderTestCached().and(WellBehavingTaskSpec::assertInitialState)));
        return this;
    }

    public WellBehavingTaskPropertyBuilder incremental(@NonNull WellBehavingTaskTransform transform, WellBehavingTaskAssertion assertion) {
        if (transform == null) {
            throw new NullPointerException("transform is marked non-null but is null");
        }
        this.incrementalChecks.add(new WellBehavingTaskTestCase(this.propertyName, transform, assertion));
        return this;
    }

    public WellBehavingTaskProperty build() {
        return new WellBehavingTaskProperty(this.propertyName, new WellBehavingTaskTestSuite.UpToDateTestSuite(this.upToDateChecks), new WellBehavingTaskTestSuite.CacheableTestSuite(this.cacheableChecks), new WellBehavingTaskTestSuite.IncrementalTestSuite(this.incrementalChecks), this.mutator.configureWith(this.initialValue));
    }

    public WellBehavingTaskProperty ignore() {
        assert (this.upToDateChecks.isEmpty());
        assert (this.incrementalChecks.isEmpty());
        assert (this.cacheableChecks.isEmpty());
        return WellBehavingTaskProperty.ignored(this.propertyName, this.initialValue == null ? "" : this.mutator.configureWith(this.initialValue));
    }
}

