/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.ide.xcode.internal.xcodeproj;

import com.google.common.base.CharMatcher;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import dev.nokee.ide.xcode.internal.xcodeproj.PBXContainerItem;
import dev.nokee.ide.xcode.internal.xcodeproj.XcodeprojSerializer;
import javax.annotation.Nullable;

public class PBXReference
extends PBXContainerItem {
    private final String name;
    @Nullable
    private String path;
    private SourceTree sourceTree;

    public PBXReference(String name, @Nullable String path, SourceTree sourceTree) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.path = path;
        this.sourceTree = (SourceTree)((Object)Preconditions.checkNotNull((Object)((Object)sourceTree)));
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public void setPath(String v) {
        this.path = v;
    }

    public SourceTree getSourceTree() {
        return this.sourceTree;
    }

    public void setSourceTree(SourceTree v) {
        this.sourceTree = v;
    }

    @Override
    public String isa() {
        return "PBXReference";
    }

    @Override
    public int stableHash() {
        return this.name.hashCode();
    }

    @Override
    public void serializeInto(XcodeprojSerializer s) {
        super.serializeInto(s);
        s.addField("name", this.name);
        if (this.path != null) {
            s.addField("path", this.path);
        }
        s.addField("sourceTree", this.sourceTree.toString());
    }

    @Override
    public String toString() {
        return String.format("%s name=%s path=%s sourceTree=%s", new Object[]{super.toString(), this.getName(), this.getPath(), this.getSourceTree()});
    }

    public static enum SourceTree {
        GROUP("<group>"),
        ABSOLUTE("<absolute>"),
        BUILT_PRODUCTS_DIR("BUILT_PRODUCTS_DIR"),
        SDKROOT("SDKROOT"),
        SOURCE_ROOT("SOURCE_ROOT"),
        DEVELOPER_DIR("DEVELOPER_DIR");

        private final String rep;

        private SourceTree(String str) {
            this.rep = str;
        }

        public static Optional<SourceTree> fromBuildSetting(String buildSetting) {
            String data;
            switch (data = CharMatcher.is((char)'$').trimLeadingFrom((CharSequence)buildSetting)) {
                case "BUILT_PRODUCTS_DIR": {
                    return Optional.of((Object)((Object)BUILT_PRODUCTS_DIR));
                }
                case "SDKROOT": {
                    return Optional.of((Object)((Object)SDKROOT));
                }
                case "SOURCE_ROOT": {
                    return Optional.of((Object)((Object)SOURCE_ROOT));
                }
                case "DEVELOPER_DIR": {
                    return Optional.of((Object)((Object)DEVELOPER_DIR));
                }
            }
            return Optional.absent();
        }

        public String toString() {
            return this.rep;
        }
    }
}

