/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.ide.xcode.internal.xcodeproj;

import com.google.common.base.MoreObjects;
import com.google.common.io.Files;
import dev.nokee.ide.xcode.internal.xcodeproj.FileTypes;
import dev.nokee.ide.xcode.internal.xcodeproj.PBXReference;
import dev.nokee.ide.xcode.internal.xcodeproj.XcodeprojSerializer;
import java.util.Optional;

public class PBXFileReference
extends PBXReference {
    private Optional<String> explicitFileType;
    private Optional<String> lastKnownFileType;

    public PBXFileReference(String name, String path, PBXReference.SourceTree sourceTree) {
        this(name, path, sourceTree, Optional.empty());
    }

    public PBXFileReference(String name, String path, PBXReference.SourceTree sourceTree, Optional<String> defaultType) {
        super(name, path, sourceTree);
        String pathOrName = (String)MoreObjects.firstNonNull((Object)path, (Object)name);
        String fileType = (String)FileTypes.FILE_EXTENSION_TO_IDENTIFIER.get((Object)Files.getFileExtension((String)pathOrName));
        if (fileType != null && FileTypes.EXPLICIT_FILE_TYPE_BROKEN_IDENTIFIERS.contains((Object)fileType) || FileTypes.MODIFIABLE_FILE_TYPE_IDENTIFIERS.contains((Object)fileType)) {
            this.explicitFileType = Optional.empty();
            this.lastKnownFileType = Optional.of(fileType);
        } else if (fileType != null) {
            this.explicitFileType = Optional.of(fileType);
            this.lastKnownFileType = Optional.empty();
        } else {
            this.explicitFileType = defaultType;
            this.lastKnownFileType = Optional.empty();
        }
    }

    public Optional<String> getExplicitFileType() {
        return this.explicitFileType;
    }

    public void setExplicitFileType(Optional<String> explicitFileType) {
        this.explicitFileType = explicitFileType;
    }

    @Override
    public String isa() {
        return "PBXFileReference";
    }

    @Override
    public void serializeInto(XcodeprojSerializer s) {
        super.serializeInto(s);
        if (this.explicitFileType.isPresent()) {
            s.addField("explicitFileType", this.explicitFileType.get());
        }
        if (this.lastKnownFileType.isPresent()) {
            s.addField("lastKnownFileType", this.lastKnownFileType.get());
        }
    }

    @Override
    public String toString() {
        return String.format("%s explicitFileType=%s", super.toString(), this.getExplicitFileType());
    }
}

