/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.ide.xcode.internal.tasks;

import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dev.nokee.ide.xcode.XcodeIdeProductType;
import dev.nokee.ide.xcode.XcodeIdeProductTypes;
import dev.nokee.ide.xcode.XcodeIdeProject;
import dev.nokee.ide.xcode.XcodeIdeTarget;
import dev.nokee.ide.xcode.internal.DefaultXcodeIdeBuildSettings;
import dev.nokee.ide.xcode.internal.XcodeIdePropertyAdapter;
import dev.nokee.ide.xcode.internal.services.XcodeIdeGidGeneratorService;
import dev.nokee.ide.xcode.internal.xcodeproj.GidGenerator;
import dev.nokee.ide.xcode.internal.xcodeproj.PBXBuildFile;
import dev.nokee.ide.xcode.internal.xcodeproj.PBXFileReference;
import dev.nokee.ide.xcode.internal.xcodeproj.PBXLegacyTarget;
import dev.nokee.ide.xcode.internal.xcodeproj.PBXNativeTarget;
import dev.nokee.ide.xcode.internal.xcodeproj.PBXProject;
import dev.nokee.ide.xcode.internal.xcodeproj.PBXReference;
import dev.nokee.ide.xcode.internal.xcodeproj.PBXShellScriptBuildPhase;
import dev.nokee.ide.xcode.internal.xcodeproj.PBXSourcesBuildPhase;
import dev.nokee.ide.xcode.internal.xcodeproj.PBXTarget;
import dev.nokee.ide.xcode.internal.xcodeproj.XCBuildConfiguration;
import dev.nokee.ide.xcode.internal.xcodeproj.XcodeprojSerializer;
import dev.nokee.language.c.internal.UTTypeCSource;
import dev.nokee.language.cpp.internal.UTTypeCppSource;
import dev.nokee.language.objectivec.internal.UTTypeObjectiveCSource;
import dev.nokee.language.objectivecpp.internal.UTTypeObjectiveCppSource;
import dev.nokee.language.swift.internal.UTTypeSwiftSource;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Named;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;

public abstract class GenerateXcodeIdeProjectTask
extends DefaultTask {
    public static final XcodeIdeProductType INDEXER_PRODUCT_TYPE = XcodeIdeProductType.of("dev.nokee.product-type.indexer");
    private static final String PRODUCTS_GROUP_NAME = "Products";
    private Map<String, PBXFileReference> pathToFileReferenceMapping = new HashMap<String, PBXFileReference>();
    private final XcodeIdeProject xcodeProject;
    private static Set<String> COMPILATION_UNITS_EXTENSIONS = ImmutableSet.builder().add((Object[])UTTypeObjectiveCSource.INSTANCE.getFilenameExtensions()).add((Object[])UTTypeCppSource.INSTANCE.getFilenameExtensions()).add((Object[])UTTypeCSource.INSTANCE.getFilenameExtensions()).add((Object[])UTTypeObjectiveCppSource.INSTANCE.getFilenameExtensions()).add((Object[])UTTypeSwiftSource.INSTANCE.getFilenameExtensions()).build();

    @Internal
    public abstract Property<FileSystemLocation> getProjectLocation();

    @Internal
    public abstract Property<XcodeIdeGidGeneratorService> getGidGenerator();

    @Internal
    public abstract Property<String> getGradleCommand();

    @Internal
    public abstract Property<String> getBridgeTaskPath();

    @Internal
    public abstract ListProperty<String> getAdditionalGradleArguments();

    @Internal
    public abstract ConfigurableFileCollection getSources();

    @Inject
    public GenerateXcodeIdeProjectTask(final XcodeIdeProject xcodeProject) {
        this.xcodeProject = xcodeProject;
        this.dependsOn(new Object[]{new TaskDependencyContainer(){

            public void visitDependencies(TaskDependencyResolveContext context) {
                xcodeProject.getTargets().stream().flatMap(it -> it.getBuildConfigurations().stream()).flatMap(it -> ((DefaultXcodeIdeBuildSettings)it.getBuildSettings()).getProviders().stream()).forEach(it -> {
                    if (it instanceof TaskDependencyContainer) {
                        ((TaskDependencyContainer)it).visitDependencies(context);
                    }
                });
            }
        }});
    }

    @Inject
    protected abstract ObjectFactory getObjects();

    @TaskAction
    private void generate() throws IOException {
        File projectDirectory = ((FileSystemLocation)this.getProjectLocation().get()).getAsFile();
        FileUtils.deleteDirectory((File)projectDirectory);
        projectDirectory.mkdirs();
        PBXProject project = new PBXProject(this.getProject().getPath());
        project.getTargets().addAll(this.xcodeProject.getTargets().stream().map(this::toTarget).collect(Collectors.toList()));
        this.getSources().forEach(file -> project.getMainGroup().getChildren().add(this.toAbsoluteFileReference((File)file)));
        this.xcodeProject.getTargets().forEach(target -> {
            List<PBXReference> fileReferences = project.getMainGroup().getOrCreateChildGroupByName(target.getName()).getChildren();
            target.getSources().forEach(file -> fileReferences.add(this.toAbsoluteFileReference((File)file)));
        });
        project.getMainGroup().getOrCreateChildGroupByName(PRODUCTS_GROUP_NAME).getChildren().addAll(project.getTargets().stream().map(PBXTarget::getProductReference).collect(Collectors.toList()));
        this.xcodeProject.getTargets().stream().flatMap(it -> it.getBuildConfigurations().stream()).map(Named::getName).forEach(name -> project.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked(name));
        File schemesDirectory = new File(projectDirectory, "xcshareddata/xcschemes");
        schemesDirectory.mkdirs();
        XmlMapper xmlMapper = new XmlMapper();
        SimpleModule simpleModule = new SimpleModule("BooleanAsYesNoString", new Version(1, 0, 0, null, null, null));
        simpleModule.addSerializer(Boolean.class, (JsonSerializer)new XcodeIdeBooleanSerializer());
        simpleModule.addSerializer(Boolean.TYPE, (JsonSerializer)new XcodeIdeBooleanSerializer());
        xmlMapper.registerModule((Module)simpleModule);
        xmlMapper.enable(ToXmlGenerator.Feature.WRITE_XML_DECLARATION);
        xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
        for (PBXTarget xcodeTarget : project.getTargets().stream().filter(it -> !this.isTestingTarget((PBXTarget)it)).collect(Collectors.toList())) {
            ImmutableList.Builder buildActionBuilder = ImmutableList.builder();
            buildActionBuilder.add((Object)new Scheme.BuildAction.BuildActionEntry(false, true, false, false, false, this.newBuildableReference(xcodeTarget)));
            ImmutableList.Builder testActionBuilder = ImmutableList.builder();
            project.getTargets().stream().filter(this::isTestingTarget).forEach(it -> {
                buildActionBuilder.add((Object)new Scheme.BuildAction.BuildActionEntry(true, false, false, false, false, this.newBuildableReference((PBXTarget)it)));
                testActionBuilder.add((Object)new Scheme.TestAction.TestableReference(this.newBuildableReference((PBXTarget)it)));
            });
            xmlMapper.writeValue(new File(schemesDirectory, xcodeTarget.getName() + ".xcscheme"), (Object)new Scheme(new Scheme.BuildAction((List<Scheme.BuildAction.BuildActionEntry>)buildActionBuilder.build()), new Scheme.TestAction((List<Scheme.TestAction.TestableReference>)testActionBuilder.build()), new Scheme.LaunchAction(xcodeTarget.getProductType().equals(XcodeIdeProductTypes.DYNAMIC_LIBRARY) ? null : new Scheme.LaunchAction.BuildableProductRunnable(this.newBuildableReference(xcodeTarget)))));
        }
        project.getTargets().addAll(this.xcodeProject.getTargets().stream().filter(this::isIndexableTarget).map(this::toIndexTarget).collect(Collectors.toList()));
        XcodeprojSerializer serializer = new XcodeprojSerializer((GidGenerator)this.getGidGenerator().get(), project);
        NSDictionary rootObject = serializer.toPlist();
        PropertyListParser.saveAsASCII((NSDictionary)rootObject, (File)new File(projectDirectory, "project.pbxproj"));
        File workspaceSettingsFile = new File(projectDirectory, "project.xcworkspace/xcshareddata/WorkspaceSettings.xcsettings");
        workspaceSettingsFile.getParentFile().mkdirs();
        FileUtils.writeStringToFile((File)workspaceSettingsFile, (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">\n<dict>\n\t<key>IDEWorkspaceSharedSettings_AutocreateContextsIfNeeded</key>\n\t<false/>\n</dict>\n</plist>", (Charset)Charset.defaultCharset());
    }

    private boolean isTestingTarget(PBXTarget xcodeTarget) {
        return this.isTestingProductType(xcodeTarget.getProductType());
    }

    private boolean isTestingProductType(XcodeIdeProductType productType) {
        return productType.equals(XcodeIdeProductTypes.UNIT_TEST) || productType.equals(XcodeIdeProductTypes.UI_TEST);
    }

    private Scheme.BuildableReference newBuildableReference(PBXTarget xcodeTarget) {
        return new Scheme.BuildableReference(xcodeTarget.getGlobalID(), xcodeTarget.getProductName(), xcodeTarget.getName(), "container:" + ((FileSystemLocation)this.getProjectLocation().get()).getAsFile().getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isIndexableTarget(XcodeIdeTarget xcodeTarget) {
        if (((XcodeIdeProductType)xcodeTarget.getProductType().get()).equals(XcodeIdeProductTypes.UNIT_TEST)) return false;
        if (((XcodeIdeProductType)xcodeTarget.getProductType().get()).equals(XcodeIdeProductTypes.UI_TEST)) return false;
        if (!Arrays.stream(XcodeIdeProductTypes.getKnownValues()).anyMatch(((XcodeIdeProductType)xcodeTarget.getProductType().get())::equals)) return false;
        return true;
    }

    private PBXTarget toTarget(XcodeIdeTarget xcodeTarget) {
        if (this.isTestingProductType((XcodeIdeProductType)xcodeTarget.getProductType().get())) {
            return this.toGradleXCTestTarget(xcodeTarget);
        }
        return this.toGradleTarget(xcodeTarget);
    }

    private PBXTarget toGradleXCTestTarget(XcodeIdeTarget xcodeTarget) {
        PBXNativeTarget target = new PBXNativeTarget(xcodeTarget.getName(), (XcodeIdeProductType)xcodeTarget.getProductType().get());
        target.getBuildPhases().add(this.newGradleBuildPhase());
        target.getBuildPhases().add(this.newSourcesBuildPhase((FileCollection)xcodeTarget.getSources()));
        target.setProductName((String)xcodeTarget.getProductName().get());
        target.setGlobalID(((XcodeIdeGidGeneratorService)this.getGidGenerator().get()).generateGid("PBXNativeTarget", xcodeTarget.getName().hashCode()));
        PBXFileReference productReference = new PBXFileReference((String)xcodeTarget.getProductReference().get(), (String)xcodeTarget.getProductReference().get(), PBXReference.SourceTree.BUILT_PRODUCTS_DIR);
        target.setProductReference(productReference);
        xcodeTarget.getBuildConfigurations().forEach(buildConfiguration -> {
            NSDictionary settings = ((XCBuildConfiguration)target.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)buildConfiguration.getName())).getBuildSettings();
            settings.put("__DO_NOT_CHANGE_ANY_VALUE_HERE__", (Object)"Instead, use the build.gradle[.kts] files.");
            for (Map.Entry entry : ((Map)buildConfiguration.getBuildSettings().getElements().get()).entrySet()) {
                settings.put((String)entry.getKey(), GenerateXcodeIdeProjectTask.toValue(entry.getValue()));
            }
            settings.put("ONLY_ACTIVE_ARCH", (Object)"YES");
            settings.put("ENABLE_TESTABILITY", (Object)"YES");
            settings.put("CLANG_ENABLE_OBJC_ARC", (Object)"YES");
            settings.put("DONT_RUN_SWIFT_STDLIB_TOOL", (Object)"YES");
            settings.put("DEBUG_INFORMATION_FORMAT", (Object)"dwarf");
            settings.put("CC", (Object)"true");
            settings.put("LD", (Object)"true");
            settings.put("CPLUSPLUS", (Object)"true");
            settings.put("LDPLUSPLUS", (Object)"true");
        });
        return target;
    }

    private PBXTarget toIndexTarget(XcodeIdeTarget xcodeTarget) {
        PBXFileReference productReference = new PBXFileReference((String)xcodeTarget.getProductReference().get(), (String)xcodeTarget.getProductReference().get(), PBXReference.SourceTree.BUILT_PRODUCTS_DIR);
        PBXNativeTarget target = new PBXNativeTarget("__indexer_" + xcodeTarget.getName(), INDEXER_PRODUCT_TYPE);
        target.setProductName((String)xcodeTarget.getProductName().get());
        target.getBuildPhases().add(this.newSourcesBuildPhase((FileCollection)xcodeTarget.getSources()));
        target.setGlobalID(((XcodeIdeGidGeneratorService)this.getGidGenerator().get()).generateGid("PBXNativeTarget", xcodeTarget.getName().hashCode()));
        target.setProductReference(productReference);
        xcodeTarget.getBuildConfigurations().forEach(buildConfiguration -> {
            NSDictionary settings = ((XCBuildConfiguration)target.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)buildConfiguration.getName())).getBuildSettings();
            settings.put("__DO_NOT_CHANGE_ANY_VALUE_HERE__", (Object)"Instead, use the build.gradle[.kts] files.");
            for (Map.Entry entry : ((Map)buildConfiguration.getBuildSettings().getElements().get()).entrySet()) {
                settings.put((String)entry.getKey(), GenerateXcodeIdeProjectTask.toValue(entry.getValue()));
            }
        });
        return target;
    }

    private PBXSourcesBuildPhase newSourcesBuildPhase(FileCollection sourceFiles) {
        PBXSourcesBuildPhase result = new PBXSourcesBuildPhase();
        for (File file : sourceFiles.filter(GenerateXcodeIdeProjectTask::keepingOnlyCompilationUnits)) {
            result.getFiles().add(new PBXBuildFile(this.toAbsoluteFileReference(file)));
        }
        return result;
    }

    private static boolean keepingOnlyCompilationUnits(File sourceFile) {
        return COMPILATION_UNITS_EXTENSIONS.contains(FilenameUtils.getExtension((String)sourceFile.getName()));
    }

    private PBXTarget toGradleTarget(XcodeIdeTarget xcodeTarget) {
        PBXFileReference productReference = this.toBuildProductFileReference((String)xcodeTarget.getProductReference().get());
        PBXLegacyTarget target = new PBXLegacyTarget(xcodeTarget.getName(), (XcodeIdeProductType)xcodeTarget.getProductType().get());
        target.setProductName((String)xcodeTarget.getProductName().get());
        target.setBuildToolPath((String)this.getGradleCommand().get());
        target.setBuildArgumentsString(this.getGradleBuildArgumentsString());
        target.setGlobalID(((XcodeIdeGidGeneratorService)this.getGidGenerator().get()).generateGid("PBXLegacyTarget", xcodeTarget.getName().hashCode()));
        target.setProductReference(productReference);
        target.setPassBuildSettingsInEnvironment(false);
        xcodeTarget.getBuildConfigurations().forEach(buildConfiguration -> {
            NSDictionary settings = ((XCBuildConfiguration)target.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)buildConfiguration.getName())).getBuildSettings();
            settings.put("__DO_NOT_CHANGE_ANY_VALUE_HERE__", (Object)"Instead, use the build.gradle[.kts] files.");
            for (Map.Entry entry : ((Map)buildConfiguration.getBuildSettings().getElements().get()).entrySet()) {
                settings.put((String)entry.getKey(), GenerateXcodeIdeProjectTask.toValue(entry.getValue()));
            }
            settings.put("PRODUCT_NAME", xcodeTarget.getProductReference().get());
        });
        return target;
    }

    private PBXShellScriptBuildPhase newGradleBuildPhase() {
        PBXShellScriptBuildPhase result = new PBXShellScriptBuildPhase();
        result.setShellPath("/bin/sh");
        result.setShellScript("exec \"" + (String)this.getGradleCommand().get() + "\" " + this.getGradleBuildArgumentsString() + " < /dev/null");
        result.getInputPaths().add("$(TARGET_BUILD_DIR)/$(INFOPLIST_PATH)");
        return result;
    }

    private String getGradleBuildArgumentsString() {
        return String.join((CharSequence)" ", Iterables.concat(XcodeIdePropertyAdapter.getAdapterCommandLine(), (Iterable)((Iterable)this.getAdditionalGradleArguments().get()))) + " " + (String)this.getBridgeTaskPath().get();
    }

    private static NSObject toValue(Object o) {
        if (o instanceof Integer) {
            return new NSNumber(((Integer)o).intValue());
        }
        if (o instanceof Long) {
            return new NSNumber(((Long)o).longValue());
        }
        if (o instanceof Double) {
            return new NSNumber(((Double)o).doubleValue());
        }
        if (o instanceof Collection) {
            NSArray result = new NSArray(((Collection)o).size());
            int key = 0;
            for (Object obj : (Collection)o) {
                result.setValue(key, (Object)GenerateXcodeIdeProjectTask.toValue(obj));
                ++key;
            }
            return result;
        }
        return new NSString(o.toString());
    }

    private PBXFileReference toAbsoluteFileReference(File file) {
        return this.computeFileReferenceIfAbsent(file.getAbsolutePath(), path -> new PBXFileReference(file.getName(), file.getAbsolutePath(), PBXReference.SourceTree.ABSOLUTE));
    }

    private PBXFileReference toBuildProductFileReference(String name) {
        return this.computeFileReferenceIfAbsent(name, key -> new PBXFileReference(name, name, PBXReference.SourceTree.BUILT_PRODUCTS_DIR));
    }

    private PBXFileReference computeFileReferenceIfAbsent(String key, Function<String, PBXFileReference> provider) {
        return this.pathToFileReferenceMapping.computeIfAbsent(key, provider);
    }

    private static final class Scheme {
        @JacksonXmlProperty(localName="BuildAction")
        private final BuildAction buildAction;
        @JacksonXmlProperty(localName="TestAction")
        private final TestAction testAction;
        @JacksonXmlProperty(localName="LaunchAction")
        private final LaunchAction launchAction;
        @JacksonXmlProperty(localName="ProfileAction")
        private final ProfileAction profileAction = new ProfileAction();
        @JacksonXmlProperty(localName="AnalyzeAction")
        private final AnalyzeAction analyzeAction = new AnalyzeAction();
        @JacksonXmlProperty(localName="ArchiveAction")
        private final ArchiveAction archiveAction = new ArchiveAction();

        @JacksonXmlProperty(localName="LastUpgradeVersion", isAttribute=true)
        public String getLastUpgradeVersion() {
            return "0830";
        }

        @JacksonXmlProperty(isAttribute=true)
        public String getVersion() {
            return "1.3";
        }

        public Scheme(BuildAction buildAction, TestAction testAction, LaunchAction launchAction) {
            this.buildAction = buildAction;
            this.testAction = testAction;
            this.launchAction = launchAction;
        }

        public BuildAction getBuildAction() {
            return this.buildAction;
        }

        public TestAction getTestAction() {
            return this.testAction;
        }

        public LaunchAction getLaunchAction() {
            return this.launchAction;
        }

        public ProfileAction getProfileAction() {
            return this.profileAction;
        }

        public AnalyzeAction getAnalyzeAction() {
            return this.analyzeAction;
        }

        public ArchiveAction getArchiveAction() {
            return this.archiveAction;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Scheme)) {
                return false;
            }
            Scheme other = (Scheme)o;
            BuildAction this$buildAction = this.getBuildAction();
            BuildAction other$buildAction = other.getBuildAction();
            if (this$buildAction == null ? other$buildAction != null : !((Object)this$buildAction).equals(other$buildAction)) {
                return false;
            }
            TestAction this$testAction = this.getTestAction();
            TestAction other$testAction = other.getTestAction();
            if (this$testAction == null ? other$testAction != null : !((Object)this$testAction).equals(other$testAction)) {
                return false;
            }
            LaunchAction this$launchAction = this.getLaunchAction();
            LaunchAction other$launchAction = other.getLaunchAction();
            if (this$launchAction == null ? other$launchAction != null : !((Object)this$launchAction).equals(other$launchAction)) {
                return false;
            }
            ProfileAction this$profileAction = this.getProfileAction();
            ProfileAction other$profileAction = other.getProfileAction();
            if (this$profileAction == null ? other$profileAction != null : !((Object)this$profileAction).equals(other$profileAction)) {
                return false;
            }
            AnalyzeAction this$analyzeAction = this.getAnalyzeAction();
            AnalyzeAction other$analyzeAction = other.getAnalyzeAction();
            if (this$analyzeAction == null ? other$analyzeAction != null : !((Object)this$analyzeAction).equals(other$analyzeAction)) {
                return false;
            }
            ArchiveAction this$archiveAction = this.getArchiveAction();
            ArchiveAction other$archiveAction = other.getArchiveAction();
            return !(this$archiveAction == null ? other$archiveAction != null : !((Object)this$archiveAction).equals(other$archiveAction));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BuildAction $buildAction = this.getBuildAction();
            result = result * 59 + ($buildAction == null ? 43 : ((Object)$buildAction).hashCode());
            TestAction $testAction = this.getTestAction();
            result = result * 59 + ($testAction == null ? 43 : ((Object)$testAction).hashCode());
            LaunchAction $launchAction = this.getLaunchAction();
            result = result * 59 + ($launchAction == null ? 43 : ((Object)$launchAction).hashCode());
            ProfileAction $profileAction = this.getProfileAction();
            result = result * 59 + ($profileAction == null ? 43 : ((Object)$profileAction).hashCode());
            AnalyzeAction $analyzeAction = this.getAnalyzeAction();
            result = result * 59 + ($analyzeAction == null ? 43 : ((Object)$analyzeAction).hashCode());
            ArchiveAction $archiveAction = this.getArchiveAction();
            result = result * 59 + ($archiveAction == null ? 43 : ((Object)$archiveAction).hashCode());
            return result;
        }

        public String toString() {
            return "GenerateXcodeIdeProjectTask.Scheme(buildAction=" + this.getBuildAction() + ", testAction=" + this.getTestAction() + ", launchAction=" + this.getLaunchAction() + ", profileAction=" + this.getProfileAction() + ", analyzeAction=" + this.getAnalyzeAction() + ", archiveAction=" + this.getArchiveAction() + ")";
        }

        @JsonNaming(value=PropertyNamingStrategy.UpperCamelCaseStrategy.class)
        public static final class BuildableReference {
            @JacksonXmlProperty(isAttribute=true)
            private final String blueprintIdentifier;
            @JacksonXmlProperty(isAttribute=true)
            private final String buildableName;
            @JacksonXmlProperty(isAttribute=true)
            private final String blueprintName;
            @JacksonXmlProperty(isAttribute=true)
            private final String referencedContainer;

            @JacksonXmlProperty(isAttribute=true)
            public String getBuildableIdentifier() {
                return "primary";
            }

            public BuildableReference(String blueprintIdentifier, String buildableName, String blueprintName, String referencedContainer) {
                this.blueprintIdentifier = blueprintIdentifier;
                this.buildableName = buildableName;
                this.blueprintName = blueprintName;
                this.referencedContainer = referencedContainer;
            }

            public String getBlueprintIdentifier() {
                return this.blueprintIdentifier;
            }

            public String getBuildableName() {
                return this.buildableName;
            }

            public String getBlueprintName() {
                return this.blueprintName;
            }

            public String getReferencedContainer() {
                return this.referencedContainer;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BuildableReference)) {
                    return false;
                }
                BuildableReference other = (BuildableReference)o;
                String this$blueprintIdentifier = this.getBlueprintIdentifier();
                String other$blueprintIdentifier = other.getBlueprintIdentifier();
                if (this$blueprintIdentifier == null ? other$blueprintIdentifier != null : !this$blueprintIdentifier.equals(other$blueprintIdentifier)) {
                    return false;
                }
                String this$buildableName = this.getBuildableName();
                String other$buildableName = other.getBuildableName();
                if (this$buildableName == null ? other$buildableName != null : !this$buildableName.equals(other$buildableName)) {
                    return false;
                }
                String this$blueprintName = this.getBlueprintName();
                String other$blueprintName = other.getBlueprintName();
                if (this$blueprintName == null ? other$blueprintName != null : !this$blueprintName.equals(other$blueprintName)) {
                    return false;
                }
                String this$referencedContainer = this.getReferencedContainer();
                String other$referencedContainer = other.getReferencedContainer();
                return !(this$referencedContainer == null ? other$referencedContainer != null : !this$referencedContainer.equals(other$referencedContainer));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $blueprintIdentifier = this.getBlueprintIdentifier();
                result = result * 59 + ($blueprintIdentifier == null ? 43 : $blueprintIdentifier.hashCode());
                String $buildableName = this.getBuildableName();
                result = result * 59 + ($buildableName == null ? 43 : $buildableName.hashCode());
                String $blueprintName = this.getBlueprintName();
                result = result * 59 + ($blueprintName == null ? 43 : $blueprintName.hashCode());
                String $referencedContainer = this.getReferencedContainer();
                result = result * 59 + ($referencedContainer == null ? 43 : $referencedContainer.hashCode());
                return result;
            }

            public String toString() {
                return "GenerateXcodeIdeProjectTask.Scheme.BuildableReference(blueprintIdentifier=" + this.getBlueprintIdentifier() + ", buildableName=" + this.getBuildableName() + ", blueprintName=" + this.getBlueprintName() + ", referencedContainer=" + this.getReferencedContainer() + ")";
            }
        }

        public static final class ArchiveAction {
            @JacksonXmlProperty(isAttribute=true)
            public String getBuildConfiguration() {
                return "Default";
            }

            @JacksonXmlProperty(isAttribute=true)
            public boolean getRevealArchiveInOrganizer() {
                return true;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                return o instanceof ArchiveAction;
            }

            public int hashCode() {
                boolean result = true;
                return 1;
            }

            public String toString() {
                return "GenerateXcodeIdeProjectTask.Scheme.ArchiveAction()";
            }
        }

        public static final class AnalyzeAction {
            @JacksonXmlProperty(isAttribute=true)
            public String getBuildConfiguration() {
                return "Default";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                return o instanceof AnalyzeAction;
            }

            public int hashCode() {
                boolean result = true;
                return 1;
            }

            public String toString() {
                return "GenerateXcodeIdeProjectTask.Scheme.AnalyzeAction()";
            }
        }

        public static final class ProfileAction {
            @JacksonXmlProperty(isAttribute=true)
            public String getBuildConfiguration() {
                return "Default";
            }

            @JacksonXmlProperty(isAttribute=true)
            public boolean getShouldUseLaunchSchemeArgsEnv() {
                return true;
            }

            @JacksonXmlProperty(isAttribute=true)
            public String getSavedToolIdentifier() {
                return "";
            }

            @JacksonXmlProperty(isAttribute=true)
            public boolean getUseCustomWorkingDirectory() {
                return false;
            }

            @JacksonXmlProperty(isAttribute=true)
            public boolean getDebugDocumentVersioning() {
                return true;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                return o instanceof ProfileAction;
            }

            public int hashCode() {
                boolean result = true;
                return 1;
            }

            public String toString() {
                return "GenerateXcodeIdeProjectTask.Scheme.ProfileAction()";
            }
        }

        public static final class LaunchAction {
            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            @JacksonXmlProperty(localName="BuildableProductRunnable")
            private final BuildableProductRunnable buildableProductRunnable;

            @JacksonXmlProperty(isAttribute=true)
            public String getBuildConfiguration() {
                return "Default";
            }

            @JacksonXmlProperty(isAttribute=true)
            public String getSelectedDebuggerIdentifier() {
                return "Xcode.DebuggerFoundation.Debugger.LLDB";
            }

            @JacksonXmlProperty(isAttribute=true)
            public String getSelectedLauncherIdentifier() {
                return "Xcode.DebuggerFoundation.Launcher.LLDB";
            }

            @JacksonXmlProperty(isAttribute=true)
            public String getLaunchStyle() {
                return "0";
            }

            @JacksonXmlProperty(isAttribute=true)
            public boolean getUseCustomWorkingDirectory() {
                return false;
            }

            @JacksonXmlProperty(isAttribute=true)
            public boolean getIgnoresPersistentStateOnLaunch() {
                return false;
            }

            @JacksonXmlProperty(isAttribute=true)
            public boolean getDebugDocumentVersioning() {
                return true;
            }

            @JacksonXmlProperty(isAttribute=true)
            public String getDebugServiceExtension() {
                return "internal";
            }

            @JacksonXmlProperty(isAttribute=true)
            public boolean getAllowLocationSimulation() {
                return true;
            }

            public LaunchAction(BuildableProductRunnable buildableProductRunnable) {
                this.buildableProductRunnable = buildableProductRunnable;
            }

            public BuildableProductRunnable getBuildableProductRunnable() {
                return this.buildableProductRunnable;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LaunchAction)) {
                    return false;
                }
                LaunchAction other = (LaunchAction)o;
                BuildableProductRunnable this$buildableProductRunnable = this.getBuildableProductRunnable();
                BuildableProductRunnable other$buildableProductRunnable = other.getBuildableProductRunnable();
                return !(this$buildableProductRunnable == null ? other$buildableProductRunnable != null : !((Object)this$buildableProductRunnable).equals(other$buildableProductRunnable));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                BuildableProductRunnable $buildableProductRunnable = this.getBuildableProductRunnable();
                result = result * 59 + ($buildableProductRunnable == null ? 43 : ((Object)$buildableProductRunnable).hashCode());
                return result;
            }

            public String toString() {
                return "GenerateXcodeIdeProjectTask.Scheme.LaunchAction(buildableProductRunnable=" + this.getBuildableProductRunnable() + ")";
            }

            public static final class BuildableProductRunnable {
                @JacksonXmlProperty(localName="BuildableReference")
                private final BuildableReference buildableReference;

                @JacksonXmlProperty(isAttribute=true)
                public String getRunnableDebuggingMode() {
                    return "0";
                }

                public BuildableProductRunnable(BuildableReference buildableReference) {
                    this.buildableReference = buildableReference;
                }

                public BuildableReference getBuildableReference() {
                    return this.buildableReference;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BuildableProductRunnable)) {
                        return false;
                    }
                    BuildableProductRunnable other = (BuildableProductRunnable)o;
                    BuildableReference this$buildableReference = this.getBuildableReference();
                    BuildableReference other$buildableReference = other.getBuildableReference();
                    return !(this$buildableReference == null ? other$buildableReference != null : !((Object)this$buildableReference).equals(other$buildableReference));
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    BuildableReference $buildableReference = this.getBuildableReference();
                    result = result * 59 + ($buildableReference == null ? 43 : ((Object)$buildableReference).hashCode());
                    return result;
                }

                public String toString() {
                    return "GenerateXcodeIdeProjectTask.Scheme.LaunchAction.BuildableProductRunnable(buildableReference=" + this.getBuildableReference() + ")";
                }
            }
        }

        public static final class TestAction {
            @JacksonXmlElementWrapper(localName="Testables")
            @JacksonXmlProperty(localName="TestableReference")
            private final List<TestableReference> testables;

            @JacksonXmlProperty(isAttribute=true)
            public String getBuildConfiguration() {
                return "Default";
            }

            @JacksonXmlProperty(isAttribute=true)
            public String getSelectedDebuggerIdentifier() {
                return "Xcode.DebuggerFoundation.Debugger.LLDB";
            }

            @JacksonXmlProperty(isAttribute=true)
            public String getSelectedLauncherIdentifier() {
                return "Xcode.DebuggerFoundation.Launcher.LLDB";
            }

            @JacksonXmlProperty(isAttribute=true)
            public boolean getShouldUseLaunchSchemeArgsEnv() {
                return true;
            }

            public TestAction(List<TestableReference> testables) {
                this.testables = testables;
            }

            public List<TestableReference> getTestables() {
                return this.testables;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TestAction)) {
                    return false;
                }
                TestAction other = (TestAction)o;
                List<TestableReference> this$testables = this.getTestables();
                List<TestableReference> other$testables = other.getTestables();
                return !(this$testables == null ? other$testables != null : !((Object)this$testables).equals(other$testables));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<TestableReference> $testables = this.getTestables();
                result = result * 59 + ($testables == null ? 43 : ((Object)$testables).hashCode());
                return result;
            }

            public String toString() {
                return "GenerateXcodeIdeProjectTask.Scheme.TestAction(testables=" + this.getTestables() + ")";
            }

            public static final class TestableReference {
                @JacksonXmlProperty(localName="BuildableReference")
                private final BuildableReference buildableReference;

                @JacksonXmlProperty(isAttribute=true)
                public boolean getSkipped() {
                    return false;
                }

                public TestableReference(BuildableReference buildableReference) {
                    this.buildableReference = buildableReference;
                }

                public BuildableReference getBuildableReference() {
                    return this.buildableReference;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof TestableReference)) {
                        return false;
                    }
                    TestableReference other = (TestableReference)o;
                    BuildableReference this$buildableReference = this.getBuildableReference();
                    BuildableReference other$buildableReference = other.getBuildableReference();
                    return !(this$buildableReference == null ? other$buildableReference != null : !((Object)this$buildableReference).equals(other$buildableReference));
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    BuildableReference $buildableReference = this.getBuildableReference();
                    result = result * 59 + ($buildableReference == null ? 43 : ((Object)$buildableReference).hashCode());
                    return result;
                }

                public String toString() {
                    return "GenerateXcodeIdeProjectTask.Scheme.TestAction.TestableReference(buildableReference=" + this.getBuildableReference() + ")";
                }
            }
        }

        public static final class BuildAction {
            @JacksonXmlElementWrapper(localName="BuildActionEntries")
            @JacksonXmlProperty(localName="BuildActionEntry")
            private final List<BuildActionEntry> buildActionEntries;

            @JacksonXmlProperty(isAttribute=true)
            public boolean getParallelizeBuildables() {
                return false;
            }

            @JacksonXmlProperty(isAttribute=true)
            public boolean getBuildImplicitDependencies() {
                return false;
            }

            public BuildAction(List<BuildActionEntry> buildActionEntries) {
                this.buildActionEntries = buildActionEntries;
            }

            public List<BuildActionEntry> getBuildActionEntries() {
                return this.buildActionEntries;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BuildAction)) {
                    return false;
                }
                BuildAction other = (BuildAction)o;
                List<BuildActionEntry> this$buildActionEntries = this.getBuildActionEntries();
                List<BuildActionEntry> other$buildActionEntries = other.getBuildActionEntries();
                return !(this$buildActionEntries == null ? other$buildActionEntries != null : !((Object)this$buildActionEntries).equals(other$buildActionEntries));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<BuildActionEntry> $buildActionEntries = this.getBuildActionEntries();
                result = result * 59 + ($buildActionEntries == null ? 43 : ((Object)$buildActionEntries).hashCode());
                return result;
            }

            public String toString() {
                return "GenerateXcodeIdeProjectTask.Scheme.BuildAction(buildActionEntries=" + this.getBuildActionEntries() + ")";
            }

            public static final class BuildActionEntry {
                @JacksonXmlProperty(isAttribute=true)
                private final boolean buildForTesting;
                @JacksonXmlProperty(isAttribute=true)
                private final boolean buildForRunning;
                @JacksonXmlProperty(isAttribute=true)
                private final boolean buildForProfiling;
                @JacksonXmlProperty(isAttribute=true)
                private final boolean buildForArchiving;
                @JacksonXmlProperty(isAttribute=true)
                private final boolean buildForAnalyzing;
                @JacksonXmlProperty(localName="BuildableReference")
                private final BuildableReference buildableReference;

                public BuildActionEntry(boolean buildForTesting, boolean buildForRunning, boolean buildForProfiling, boolean buildForArchiving, boolean buildForAnalyzing, BuildableReference buildableReference) {
                    this.buildForTesting = buildForTesting;
                    this.buildForRunning = buildForRunning;
                    this.buildForProfiling = buildForProfiling;
                    this.buildForArchiving = buildForArchiving;
                    this.buildForAnalyzing = buildForAnalyzing;
                    this.buildableReference = buildableReference;
                }

                public boolean isBuildForTesting() {
                    return this.buildForTesting;
                }

                public boolean isBuildForRunning() {
                    return this.buildForRunning;
                }

                public boolean isBuildForProfiling() {
                    return this.buildForProfiling;
                }

                public boolean isBuildForArchiving() {
                    return this.buildForArchiving;
                }

                public boolean isBuildForAnalyzing() {
                    return this.buildForAnalyzing;
                }

                public BuildableReference getBuildableReference() {
                    return this.buildableReference;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BuildActionEntry)) {
                        return false;
                    }
                    BuildActionEntry other = (BuildActionEntry)o;
                    if (this.isBuildForTesting() != other.isBuildForTesting()) {
                        return false;
                    }
                    if (this.isBuildForRunning() != other.isBuildForRunning()) {
                        return false;
                    }
                    if (this.isBuildForProfiling() != other.isBuildForProfiling()) {
                        return false;
                    }
                    if (this.isBuildForArchiving() != other.isBuildForArchiving()) {
                        return false;
                    }
                    if (this.isBuildForAnalyzing() != other.isBuildForAnalyzing()) {
                        return false;
                    }
                    BuildableReference this$buildableReference = this.getBuildableReference();
                    BuildableReference other$buildableReference = other.getBuildableReference();
                    return !(this$buildableReference == null ? other$buildableReference != null : !((Object)this$buildableReference).equals(other$buildableReference));
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + (this.isBuildForTesting() ? 79 : 97);
                    result = result * 59 + (this.isBuildForRunning() ? 79 : 97);
                    result = result * 59 + (this.isBuildForProfiling() ? 79 : 97);
                    result = result * 59 + (this.isBuildForArchiving() ? 79 : 97);
                    result = result * 59 + (this.isBuildForAnalyzing() ? 79 : 97);
                    BuildableReference $buildableReference = this.getBuildableReference();
                    result = result * 59 + ($buildableReference == null ? 43 : ((Object)$buildableReference).hashCode());
                    return result;
                }

                public String toString() {
                    return "GenerateXcodeIdeProjectTask.Scheme.BuildAction.BuildActionEntry(buildForTesting=" + this.isBuildForTesting() + ", buildForRunning=" + this.isBuildForRunning() + ", buildForProfiling=" + this.isBuildForProfiling() + ", buildForArchiving=" + this.isBuildForArchiving() + ", buildForAnalyzing=" + this.isBuildForAnalyzing() + ", buildableReference=" + this.getBuildableReference() + ")";
                }
            }
        }
    }

    private static class XcodeIdeBooleanSerializer
    extends JsonSerializer<Boolean> {
        private XcodeIdeBooleanSerializer() {
        }

        public void serialize(Boolean value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (value.booleanValue()) {
                jgen.writeString("YES");
            } else {
                jgen.writeString("NO");
            }
        }
    }
}

