/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.ide.xcode.internal.plugins;

import dev.nokee.ide.xcode.XcodeIdeProductTypes;
import dev.nokee.ide.xcode.XcodeIdeProjectExtension;
import dev.nokee.platform.ios.SwiftIosApplicationExtension;
import dev.nokee.platform.ios.internal.DefaultIosApplicationComponent;
import dev.nokee.platform.ios.internal.DefaultIosApplicationVariant;
import dev.nokee.platform.ios.internal.DefaultSwiftIosApplicationExtension;
import dev.nokee.platform.ios.internal.SignedIosApplicationBundleInternal;
import dev.nokee.platform.nativebase.internal.BaseNativeBinary;
import dev.nokee.platform.nativebase.internal.ExecutableBinaryInternal;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.util.GUtil;

public abstract class XcodeIdeSwiftIosApplicationPlugin
implements Plugin<Project> {
    public void apply(final Project project) {
        DefaultIosApplicationComponent application = (DefaultIosApplicationComponent)((DefaultSwiftIosApplicationExtension)project.getExtensions().getByType(SwiftIosApplicationExtension.class)).getComponent();
        String moduleName = GUtil.toCamelCase((CharSequence)project.getName());
        ((XcodeIdeProjectExtension)project.getExtensions().getByType(XcodeIdeProjectExtension.class)).getProjects().register(project.getName(), xcodeProject -> {
            NamedDomainObjectProvider appTarget = xcodeProject.getTargets().register(moduleName, xcodeTarget -> {
                xcodeTarget.getProductName().set((Object)moduleName);
                xcodeTarget.getProductReference().set((Object)(moduleName + ".app"));
                xcodeTarget.getProductType().set((Object)XcodeIdeProductTypes.APPLICATION);
                xcodeTarget.getBuildConfigurations().register("Default", xcodeConfiguration -> {
                    Provider binary = application.getDevelopmentVariant().flatMap(it -> it.getBinaries().withType(ExecutableBinaryInternal.class).getElements().map(b -> (ExecutableBinaryInternal)b.iterator().next()));
                    xcodeConfiguration.getProductLocation().set(application.getVariants().getElements().flatMap(it -> ((SignedIosApplicationBundleInternal)((DefaultIosApplicationVariant)it.iterator().next()).getBinaries().withType(SignedIosApplicationBundleInternal.class).get().iterator().next()).getApplicationBundleLocation()));
                    xcodeConfiguration.getBuildSettings().put("BUNDLE_LOADER", "$(TEST_HOST)").put("INFOPLIST_FILE", "src/main/resources/Info.plist").put("IPHONEOS_DEPLOYMENT_TARGET", 13.2).put("PRODUCT_BUNDLE_IDENTIFIER", project.getGroup().toString() + "." + moduleName).put("PRODUCT_NAME", "$(TARGET_NAME)").put("TARGETED_DEVICE_FAMILY", "1,2").put("SDKROOT", "iphoneos").put("SWIFT_INCLUDE_PATHS", (Provider<Object>)binary.flatMap(BaseNativeBinary::getImportSearchPaths).map(this::toSpaceSeparatedList)).put("FRAMEWORK_SEARCH_PATHS", (Provider<Object>)binary.flatMap(BaseNativeBinary::getFrameworkSearchPaths).map(this::toSpaceSeparatedList)).put("COMPILER_INDEX_STORE_ENABLE", "YES").put("USE_HEADERMAP", "NO");
                });
                xcodeTarget.getSources().from(new Object[]{project.fileTree((Object)"src/main/swift", it -> it.include(new String[]{"*"}))});
                xcodeTarget.getSources().from(new Object[]{this.getProviders().provider(() -> {
                    try {
                        final ArrayList result = new ArrayList();
                        Files.walkFileTree(project.file((Object)"src/main/resources").toPath(), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                                if (path.equals(project.file((Object)"src/main/resources").toPath())) {
                                    return FileVisitResult.CONTINUE;
                                }
                                if (path.getFileName().toString().endsWith(".lproj")) {
                                    return FileVisitResult.CONTINUE;
                                }
                                result.add(path);
                                return FileVisitResult.SKIP_SUBTREE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                                result.add(path);
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFileFailed(Path path, IOException e) throws IOException {
                                return FileVisitResult.TERMINATE;
                            }

                            @Override
                            public FileVisitResult postVisitDirectory(Path path, IOException e) throws IOException {
                                return FileVisitResult.CONTINUE;
                            }
                        });
                        return result;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                })});
            });
        });
    }

    @Inject
    protected abstract TaskContainer getTasks();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract ObjectFactory getObjects();

    private String toSpaceSeparatedList(Set<FileSystemLocation> paths) {
        return paths.stream().map(location -> location.getAsFile().getAbsolutePath()).collect(Collectors.joining(" "));
    }
}

