/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.ide.xcode.internal.plugins;

import dev.nokee.ide.xcode.XcodeIdeProductTypes;
import dev.nokee.ide.xcode.XcodeIdeProjectExtension;
import dev.nokee.internal.Cast;
import dev.nokee.platform.base.internal.ComponentCollection;
import dev.nokee.platform.nativebase.ExecutableBinary;
import dev.nokee.platform.nativebase.internal.BaseNativeBinary;
import dev.nokee.platform.nativebase.internal.DefaultNativeApplicationComponent;
import dev.nokee.platform.nativebase.internal.ExecutableBinaryInternal;
import dev.nokee.platform.nativebase.tasks.LinkExecutable;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.util.GUtil;

public abstract class XcodeIdeSwiftApplicationPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        ((XcodeIdeProjectExtension)project.getExtensions().getByType(XcodeIdeProjectExtension.class)).getProjects().register(project.getName(), xcodeProject -> {
            ComponentCollection components = (ComponentCollection)Cast.uncheckedCast((String)"of type erasure", (Object)project.getExtensions().getByType(ComponentCollection.class));
            components.configureEach(DefaultNativeApplicationComponent.class, application -> xcodeProject.getTargets().register(GUtil.toCamelCase((CharSequence)project.getName()), xcodeTarget -> {
                xcodeTarget.getProductName().set((Object)GUtil.toCamelCase((CharSequence)project.getName()));
                xcodeTarget.getProductReference().set((Object)GUtil.toCamelCase((CharSequence)project.getName()));
                xcodeTarget.getProductType().set((Object)XcodeIdeProductTypes.TOOL);
                xcodeTarget.getBuildConfigurations().register("Default", xcodeConfiguration -> {
                    Provider binary = application.getDevelopmentVariant().flatMap(it -> it.getBinaries().withType(ExecutableBinaryInternal.class).getElements().map(b -> (ExecutableBinaryInternal)b.iterator().next()));
                    xcodeConfiguration.getProductLocation().set(binary.flatMap(ExecutableBinary::getLinkTask).flatMap(LinkExecutable::getLinkedFile));
                    xcodeConfiguration.getBuildSettings().put("PRODUCT_NAME", "$(TARGET_NAME)").put("SWIFT_VERSION", "5.2").put("SWIFT_INCLUDE_PATHS", (Provider<Object>)binary.flatMap(BaseNativeBinary::getImportSearchPaths).map(this::toSpaceSeparatedList)).put("FRAMEWORK_SEARCH_PATHS", (Provider<Object>)binary.flatMap(BaseNativeBinary::getFrameworkSearchPaths).map(this::toSpaceSeparatedList)).put("COMPILER_INDEX_STORE_ENABLE", "YES").put("USE_HEADERMAP", "NO");
                });
                xcodeTarget.getSources().from(new Object[]{project.fileTree((Object)"src/main/headers", it -> it.include(new String[]{"*"}))});
                application.getSourceCollection().forEach(sourceSet -> xcodeTarget.getSources().from(new Object[]{sourceSet.getAsFileTree()}));
            }));
        });
    }

    private String toSpaceSeparatedList(Set<FileSystemLocation> paths) {
        return paths.stream().map(location -> location.getAsFile().getAbsolutePath()).collect(Collectors.joining(" "));
    }
}

