/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.ide.xcode.internal.plugins;

import com.google.common.collect.ImmutableList;
import dev.nokee.ide.xcode.XcodeIdeBuildConfiguration;
import dev.nokee.ide.xcode.XcodeIdeProject;
import dev.nokee.ide.xcode.XcodeIdeProjectExtension;
import dev.nokee.ide.xcode.XcodeIdeTarget;
import dev.nokee.ide.xcode.XcodeIdeWorkspaceExtension;
import dev.nokee.ide.xcode.internal.DefaultXcodeIdeProject;
import dev.nokee.ide.xcode.internal.DefaultXcodeIdeProjectExtension;
import dev.nokee.ide.xcode.internal.DefaultXcodeIdeWorkspaceExtension;
import dev.nokee.ide.xcode.internal.XcodeIdeProjectMetadata;
import dev.nokee.ide.xcode.internal.XcodeIdePropertyAdapter;
import dev.nokee.ide.xcode.internal.plugins.XcodeIdeNativeApplicationPlugin;
import dev.nokee.ide.xcode.internal.plugins.XcodeIdeNativeLibraryPlugin;
import dev.nokee.ide.xcode.internal.plugins.XcodeIdeObjectiveCIosApplicationPlugin;
import dev.nokee.ide.xcode.internal.plugins.XcodeIdeSwiftApplicationPlugin;
import dev.nokee.ide.xcode.internal.plugins.XcodeIdeSwiftIosApplicationPlugin;
import dev.nokee.ide.xcode.internal.plugins.XcodeIdeSwiftLibraryPlugin;
import dev.nokee.ide.xcode.internal.services.XcodeIdeGidGeneratorService;
import dev.nokee.ide.xcode.internal.tasks.GenerateXcodeIdeProjectTask;
import dev.nokee.ide.xcode.internal.tasks.GenerateXcodeIdeWorkspaceTask;
import dev.nokee.ide.xcode.internal.tasks.SyncXcodeIdeProduct;
import dev.nokee.internal.ProjectUtils;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Rule;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.Actions;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.plugins.ide.internal.IdeProjectMetadata;

public abstract class XcodeIdePlugin
implements Plugin<Project> {
    public static final String IDE_GROUP_NAME = "IDE";
    public static final String XCODE_EXTENSION_NAME = "xcode";

    public void apply(final Project project) {
        DefaultXcodeIdeProjectExtension projectExtension = this.registerExtension(project);
        Optional<DefaultXcodeIdeWorkspaceExtension> workspaceExtension = XcodeIdePlugin.asWorkspaceExtensionIfAvailable(projectExtension);
        TaskProvider xcodeTask = this.getTasks().register(XCODE_EXTENSION_NAME, task -> {
            task.dependsOn(new Object[]{projectExtension.getProjects()});
            workspaceExtension.ifPresent(extension -> task.dependsOn(new Object[]{extension.getWorkspace().getGeneratorTask()}));
            task.setGroup(IDE_GROUP_NAME);
            task.setDescription("Generates Xcode IDE configuration");
        });
        workspaceExtension.ifPresent(extension -> {
            extension.getWorkspace().getProjects().set(extension.getProjects());
            extension.getWorkspace().getGeneratorTask().configure(task -> {
                task.getWorkspaceLocation().set((Object)this.getLayout().getProjectDirectory().dir(project.getName() + ".xcworkspace"));
                task.getProjectLocations().set(this.getArtifactRegistry().getIdeProjectFiles(XcodeIdeProjectMetadata.class).getElements());
                task.getDerivedDataLocation().set((Object)".gradle/XcodeDerivedData");
            });
            xcodeTask.configure(task -> task.doLast((Action)new Action<Task>(){

                public void execute(Task task) {
                    task.getLogger().lifecycle(String.format("Generated %s at %s", extension.getWorkspace().getDisplayName(), new ConsoleRenderer().asClickableFileUrl(((FileSystemLocation)extension.getWorkspace().getLocation().get()).getAsFile())));
                }
            }));
            project.getTasks().register("open" + StringUtils.capitalize((String)xcodeTask.getName()), task -> {
                task.dependsOn(new Object[]{xcodeTask});
                task.setGroup(IDE_GROUP_NAME);
                task.setDescription("Opens the " + extension.getWorkspace().getDisplayName());
                task.doLast((Action)new Action<Task>(){

                    public void execute(Task task) {
                        if (SystemUtils.IS_OS_MAC) {
                            project.exec(spec -> spec.commandLine(new Object[]{"open", extension.getWorkspace().getLocation().get()}));
                        } else {
                            try {
                                Desktop.getDesktop().open(((FileSystemLocation)extension.getWorkspace().getLocation().get()).getAsFile());
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException((Throwable)e);
                            }
                        }
                    }
                });
            });
        });
        TaskProvider cleanXcodeTask = this.getTasks().register("cleanXcode", Delete.class, task -> {
            task.setGroup(IDE_GROUP_NAME);
            task.setDescription("Cleans Xcode IDE configuration");
            task.delete(new Object[]{this.getProviders().provider(() -> projectExtension.getProjects().stream().map(XcodeIdeProject::getLocation).collect(Collectors.toList()))});
            workspaceExtension.ifPresent(extension -> {
                task.delete(new Object[]{extension.getWorkspace().getLocation()});
                task.delete(new Object[]{extension.getWorkspace().getGeneratorTask().flatMap(GenerateXcodeIdeWorkspaceTask::getDerivedDataLocation)});
            });
        });
        this.getTasks().withType(GenerateXcodeIdeProjectTask.class).configureEach(task -> task.shouldRunAfter(new Object[]{cleanXcodeTask}));
        xcodeTask.configure(task -> task.shouldRunAfter(new Object[]{cleanXcodeTask}));
        workspaceExtension.ifPresent(extension -> extension.getWorkspace().getGeneratorTask().configure(task -> task.shouldRunAfter(new Object[]{cleanXcodeTask})));
        Provider xcodeIdeGidGeneratorService = project.getGradle().getSharedServices().registerIfAbsent("xcodeIdeGidGeneratorService", XcodeIdeGidGeneratorService.class, Actions.doNothing());
        projectExtension.getProjects().withType(DefaultXcodeIdeProject.class).configureEach(xcodeProject -> xcodeProject.getGeneratorTask().configure(task -> {
            Directory projectLocation = this.getLayout().getProjectDirectory().dir(xcodeProject.getName() + ".xcodeproj");
            task.getProjectLocation().set((Object)projectLocation);
            task.usesService(xcodeIdeGidGeneratorService);
            task.getGidGenerator().set(xcodeIdeGidGeneratorService);
            task.getGradleCommand().set((Object)XcodeIdePlugin.toGradleCommand(project.getGradle()));
            task.getBridgeTaskPath().set((Object)XcodeIdePlugin.toBridgeTaskPath(project));
            task.getAdditionalGradleArguments().set(this.getAdditionalBuildArguments(project));
            task.getSources().from(new Object[]{this.getBuildFiles(project)});
        }));
        project.afterEvaluate(proj -> projectExtension.getProjects().getCollectionSchema().getElements().forEach(element -> this.getArtifactRegistry().registerIdeProject((IdeProjectMetadata)new XcodeIdeProjectMetadata((Provider<DefaultXcodeIdeProject>)projectExtension.getProjects().named(element.getName()).map(DefaultXcodeIdeProject.class::cast)))));
        project.getTasks().addRule((Rule)this.getObjects().newInstance(XcodeIdeBridge.class, new Object[]{projectExtension.getProjects(), project}));
        project.getPluginManager().withPlugin("dev.nokee.objective-c-ios-application", appliedPlugin -> project.getPluginManager().apply(XcodeIdeObjectiveCIosApplicationPlugin.class));
        project.getPluginManager().withPlugin("dev.nokee.swift-ios-application", appliedPlugin -> project.getPluginManager().apply(XcodeIdeSwiftIosApplicationPlugin.class));
        project.getPluginManager().withPlugin("dev.nokee.c-application", appliedPlugin -> project.getPluginManager().apply(XcodeIdeNativeApplicationPlugin.class));
        project.getPluginManager().withPlugin("dev.nokee.cpp-application", appliedPlugin -> project.getPluginManager().apply(XcodeIdeNativeApplicationPlugin.class));
        project.getPluginManager().withPlugin("dev.nokee.objective-c-application", appliedPlugin -> project.getPluginManager().apply(XcodeIdeNativeApplicationPlugin.class));
        project.getPluginManager().withPlugin("dev.nokee.objective-cpp-application", appliedPlugin -> project.getPluginManager().apply(XcodeIdeNativeApplicationPlugin.class));
        project.getPluginManager().withPlugin("dev.nokee.swift-application", appliedPlugin -> project.getPluginManager().apply(XcodeIdeSwiftApplicationPlugin.class));
        project.getPluginManager().withPlugin("dev.nokee.c-library", appliedPlugin -> project.getPluginManager().apply(XcodeIdeNativeLibraryPlugin.class));
        project.getPluginManager().withPlugin("dev.nokee.cpp-library", appliedPlugin -> project.getPluginManager().apply(XcodeIdeNativeLibraryPlugin.class));
        project.getPluginManager().withPlugin("dev.nokee.objective-c-library", appliedPlugin -> project.getPluginManager().apply(XcodeIdeNativeLibraryPlugin.class));
        project.getPluginManager().withPlugin("dev.nokee.objective-cpp-library", appliedPlugin -> project.getPluginManager().apply(XcodeIdeNativeLibraryPlugin.class));
        project.getPluginManager().withPlugin("dev.nokee.swift-library", appliedPlugin -> project.getPluginManager().apply(XcodeIdeSwiftLibraryPlugin.class));
    }

    private List<File> getBuildFiles(Project project) {
        ImmutableList.Builder result = ImmutableList.builder();
        if (project.getBuildFile().exists()) {
            result.add((Object)project.getBuildFile());
        }
        if (ProjectUtils.isRootProject(project)) {
            if (project.getGradle().getStartParameter().getSettingsFile() != null) {
                result.add((Object)project.getGradle().getStartParameter().getSettingsFile());
            } else if (project.file((Object)"settings.gradle").exists()) {
                result.add((Object)project.file((Object)"settings.gradle"));
            } else if (project.file((Object)"settings.gradle.kts").exists()) {
                result.add((Object)project.file((Object)"settings.gradle.kts"));
            }
            if (project.file((Object)"gradle.properties").exists()) {
                result.add((Object)project.file((Object)"gradle.properties"));
            }
            project.getGradle().getStartParameter().getInitScripts().forEach(arg_0 -> ((ImmutableList.Builder)result).add(arg_0));
        }
        return result.build();
    }

    private List<String> getAdditionalBuildArguments(Project project) {
        ImmutableList.Builder result = ImmutableList.builder();
        project.getGradle().getStartParameter().getInitScripts().forEach(initScriptFile -> result.add((Object[])new String[]{"--init-script", XcodeIdePlugin.quote(initScriptFile.getAbsolutePath())}));
        return result.build();
    }

    private static String quote(String value) {
        return "\"" + value + "\"";
    }

    private DefaultXcodeIdeProjectExtension registerExtension(Project project) {
        if (ProjectUtils.isRootProject(project)) {
            return this.registerWorkspaceExtension(project);
        }
        return this.registerProjectExtension(project);
    }

    private DefaultXcodeIdeWorkspaceExtension registerWorkspaceExtension(Project project) {
        DefaultXcodeIdeWorkspaceExtension extension = (DefaultXcodeIdeWorkspaceExtension)this.getObjects().newInstance(DefaultXcodeIdeWorkspaceExtension.class, new Object[0]);
        project.getExtensions().add(XcodeIdeWorkspaceExtension.class, XCODE_EXTENSION_NAME, (Object)extension);
        return extension;
    }

    private DefaultXcodeIdeProjectExtension registerProjectExtension(Project project) {
        DefaultXcodeIdeProjectExtension extension = (DefaultXcodeIdeProjectExtension)this.getObjects().newInstance(DefaultXcodeIdeProjectExtension.class, new Object[0]);
        project.getExtensions().add(XcodeIdeProjectExtension.class, XCODE_EXTENSION_NAME, (Object)extension);
        return extension;
    }

    private static Optional<DefaultXcodeIdeWorkspaceExtension> asWorkspaceExtensionIfAvailable(DefaultXcodeIdeProjectExtension projectExtension) {
        if (projectExtension instanceof XcodeIdeWorkspaceExtension) {
            return Optional.of((DefaultXcodeIdeWorkspaceExtension)projectExtension);
        }
        return Optional.empty();
    }

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract TaskContainer getTasks();

    @Inject
    protected abstract ProjectLayout getLayout();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract IdeArtifactRegistry getArtifactRegistry();

    private static String toBridgeTaskPath(Project project) {
        return ProjectUtils.getPrefixableProjectPath(project) + ":_xcode__${ACTION}_${PROJECT_NAME}_${TARGET_NAME}_${CONFIGURATION}";
    }

    public static String toGradleCommand(Gradle gradle) {
        Optional<Object> gradleWrapperPath = Optional.empty();
        Project rootProject = gradle.getRootProject();
        String gradlewExtension = SystemUtils.IS_OS_WINDOWS ? ".bat" : "";
        File gradlewFile = rootProject.file((Object)("gradlew" + gradlewExtension));
        if (gradlewFile.exists()) {
            gradleWrapperPath = Optional.of(gradlewFile.getAbsolutePath());
        }
        if (gradle.getGradleHomeDir() != null) {
            if (gradleWrapperPath.isPresent() && gradle.getGradleHomeDir().getAbsolutePath().startsWith(gradle.getGradleUserHomeDir().getAbsolutePath())) {
                return (String)gradleWrapperPath.get();
            }
            return gradle.getGradleHomeDir().getAbsolutePath() + "/bin/gradle";
        }
        return (String)gradleWrapperPath.orElse("gradle");
    }

    public static final class XcodeIdeRequest {
        private static final Pattern LIFECYCLE_TASK_PATTERN = Pattern.compile("_xcode__(?<action>build|clean)?_(?<project>[a-zA-Z\\-_]+)_(?<target>[a-zA-Z\\-_]+)_(?<configuration>[a-zA-Z\\-_]+)");
        private final String action;
        private final String projectName;
        private final String targetName;
        private final String configuration;

        public static XcodeIdeRequest of(String taskName) {
            Matcher m = LIFECYCLE_TASK_PATTERN.matcher(taskName);
            if (m.matches()) {
                return new XcodeIdeRequest(Optional.ofNullable(m.group("action")).orElse("build"), m.group("project"), m.group("target"), m.group("configuration"));
            }
            throw new GradleException(String.format("Unable to match the lifecycle task name '%s', it is most likely a bug. Please report it at https://github.com/nokeedev/gradle-native/issues.", taskName));
        }

        public XcodeIdeRequest(String action, String projectName, String targetName, String configuration) {
            this.action = action;
            this.projectName = projectName;
            this.targetName = targetName;
            this.configuration = configuration;
        }

        public String getAction() {
            return this.action;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getTargetName() {
            return this.targetName;
        }

        public String getConfiguration() {
            return this.configuration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof XcodeIdeRequest)) {
                return false;
            }
            XcodeIdeRequest other = (XcodeIdeRequest)o;
            String this$action = this.getAction();
            String other$action = other.getAction();
            if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
                return false;
            }
            String this$projectName = this.getProjectName();
            String other$projectName = other.getProjectName();
            if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
                return false;
            }
            String this$targetName = this.getTargetName();
            String other$targetName = other.getTargetName();
            if (this$targetName == null ? other$targetName != null : !this$targetName.equals(other$targetName)) {
                return false;
            }
            String this$configuration = this.getConfiguration();
            String other$configuration = other.getConfiguration();
            return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            String $projectName = this.getProjectName();
            result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
            String $targetName = this.getTargetName();
            result = result * 59 + ($targetName == null ? 43 : $targetName.hashCode());
            String $configuration = this.getConfiguration();
            result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
            return result;
        }

        public String toString() {
            return "XcodeIdePlugin.XcodeIdeRequest(action=" + this.getAction() + ", projectName=" + this.getProjectName() + ", targetName=" + this.getTargetName() + ", configuration=" + this.getConfiguration() + ")";
        }
    }

    protected static abstract class XcodeIdeBridge
    implements Rule {
        private final NamedDomainObjectSet<XcodeIdeProject> xcodeProjects;
        private final Project project;
        private final XcodeIdePropertyAdapter xcodePropertyAdapter;

        @Inject
        public XcodeIdeBridge(NamedDomainObjectSet<XcodeIdeProject> xcodeProjects, Project project) {
            this.xcodeProjects = xcodeProjects;
            this.project = project;
            this.xcodePropertyAdapter = new XcodeIdePropertyAdapter(project);
        }

        @Inject
        protected abstract TaskContainer getTasks();

        @Inject
        protected abstract ObjectFactory getObjects();

        public String getDescription() {
            return "Xcode IDE bridge tasks begin with _xcode. Do not call these directly.";
        }

        public void apply(String taskName) {
            if (taskName.startsWith("_xcode")) {
                XcodeIdeRequest request = XcodeIdeRequest.of(taskName);
                String action = request.getAction();
                if (action.equals("clean")) {
                    Task bridgeTask = this.getTasks().create(taskName);
                    bridgeTask.dependsOn(new Object[]{"clean"});
                } else if ("".equals(action) || "build".equals(action)) {
                    XcodeIdeTarget target = this.findXcodeTarget(request);
                    SyncXcodeIdeProduct bridgeTask = (SyncXcodeIdeProduct)this.getTasks().create(taskName, SyncXcodeIdeProduct.class);
                    this.bridgeProductBuild(bridgeTask, target, request);
                } else {
                    throw new GradleException("Unrecognized bridge action from Xcode '" + action + "'");
                }
            }
        }

        private XcodeIdeTarget findXcodeTarget(XcodeIdeRequest request) {
            String projectName = request.getProjectName();
            XcodeIdeProject project = (XcodeIdeProject)this.xcodeProjects.findByName(projectName);
            if (project == null) {
                throw new GradleException(String.format("Unknown Xcode IDE project '%s', try re-generating the Xcode IDE configuration using '%s:xcode' task.", projectName, ProjectUtils.getPrefixableProjectPath(this.project)));
            }
            String targetName = request.getTargetName();
            XcodeIdeTarget target = (XcodeIdeTarget)project.getTargets().findByName(targetName);
            if (target == null) {
                throw new GradleException(String.format("Unknown Xcode IDE target '%s', try re-generating the Xcode IDE configuration using '%s:xcode' task.", targetName, ProjectUtils.getPrefixableProjectPath(this.project)));
            }
            return target;
        }

        private void bridgeProductBuild(SyncXcodeIdeProduct bridgeTask, XcodeIdeTarget target, XcodeIdeRequest request) {
            String configurationName = request.getConfiguration();
            XcodeIdeBuildConfiguration configuration = (XcodeIdeBuildConfiguration)target.getBuildConfigurations().findByName(configurationName);
            if (configuration == null) {
                throw new GradleException(String.format("Unknown Xcode IDE configuration '%s', try re-generating the Xcode IDE configuration using '%s:xcode' task.", configurationName, ProjectUtils.getPrefixableProjectPath(this.project)));
            }
            Directory builtProductsPath = (Directory)this.getObjects().directoryProperty().fileValue(new File(this.xcodePropertyAdapter.getBuiltProductsDir())).get();
            bridgeTask.getProductLocation().convention(configuration.getProductLocation());
            bridgeTask.getDestinationLocation().convention((Object)builtProductsPath.file((String)target.getProductReference().get()));
        }
    }
}

