/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.ide.xcode.internal.plugins;

import dev.nokee.ide.xcode.XcodeIdeProductTypes;
import dev.nokee.ide.xcode.XcodeIdeProject;
import dev.nokee.ide.xcode.XcodeIdeProjectExtension;
import dev.nokee.ide.xcode.XcodeIdeTarget;
import dev.nokee.ide.xcode.internal.XcodeIdePropertyAdapter;
import dev.nokee.ide.xcode.internal.plugins.XcodeIdePlugin;
import dev.nokee.ide.xcode.internal.tasks.SyncXcodeIdeProduct;
import dev.nokee.platform.ios.ObjectiveCIosApplicationExtension;
import dev.nokee.platform.ios.internal.DefaultIosApplicationComponent;
import dev.nokee.platform.ios.internal.DefaultIosApplicationVariant;
import dev.nokee.platform.ios.internal.DefaultObjectiveCIosApplicationExtension;
import dev.nokee.platform.ios.internal.SignedIosApplicationBundleInternal;
import dev.nokee.platform.ios.tasks.internal.CreateIosApplicationBundleTask;
import dev.nokee.platform.nativebase.internal.BaseNativeBinary;
import dev.nokee.platform.nativebase.internal.ExecutableBinaryInternal;
import dev.nokee.testing.xctest.tasks.internal.CreateIosXCTestBundleTask;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.objectivec.tasks.ObjectiveCCompile;
import org.gradle.util.GUtil;

public abstract class XcodeIdeObjectiveCIosApplicationPlugin
implements Plugin<Project> {
    public void apply(final Project project) {
        DefaultIosApplicationComponent application = (DefaultIosApplicationComponent)((DefaultObjectiveCIosApplicationExtension)project.getExtensions().getByType(ObjectiveCIosApplicationExtension.class)).getComponent();
        String moduleName = GUtil.toCamelCase((CharSequence)project.getName());
        ((XcodeIdeProjectExtension)project.getExtensions().getByType(XcodeIdeProjectExtension.class)).getProjects().register(project.getName(), xcodeProject -> {
            NamedDomainObjectProvider appTarget = xcodeProject.getTargets().register(moduleName, xcodeTarget -> {
                xcodeTarget.getProductName().set((Object)moduleName);
                xcodeTarget.getProductReference().set((Object)(moduleName + ".app"));
                xcodeTarget.getProductType().set((Object)XcodeIdeProductTypes.APPLICATION);
                xcodeTarget.getBuildConfigurations().register("Default", xcodeConfiguration -> {
                    Provider binary = application.getDevelopmentVariant().flatMap(it -> it.getBinaries().withType(ExecutableBinaryInternal.class).getElements().map(b -> (ExecutableBinaryInternal)b.iterator().next()));
                    xcodeConfiguration.getProductLocation().set(application.getVariants().getElements().flatMap(it -> ((SignedIosApplicationBundleInternal)((DefaultIosApplicationVariant)it.iterator().next()).getBinaries().withType(SignedIosApplicationBundleInternal.class).get().iterator().next()).getApplicationBundleLocation()));
                    xcodeConfiguration.getBuildSettings().put("BUNDLE_LOADER", "$(TEST_HOST)").put("INFOPLIST_FILE", "src/main/resources/Info.plist").put("IPHONEOS_DEPLOYMENT_TARGET", 13.2).put("PRODUCT_BUNDLE_IDENTIFIER", project.getGroup().toString() + "." + moduleName).put("PRODUCT_NAME", "$(TARGET_NAME)").put("TARGETED_DEVICE_FAMILY", "1,2").put("SDKROOT", "iphoneos").put("USER_HEADER_SEARCH_PATHS", (Provider<Object>)binary.flatMap(BaseNativeBinary::getHeaderSearchPaths).map(this::toSpaceSeparatedList)).put("FRAMEWORK_SEARCH_PATHS", (Provider<Object>)binary.flatMap(BaseNativeBinary::getFrameworkSearchPaths).map(this::toSpaceSeparatedList)).put("COMPILER_INDEX_STORE_ENABLE", "YES").put("USE_HEADERMAP", "NO");
                });
                xcodeTarget.getSources().from(new Object[]{project.fileTree((Object)"src/main/headers", it -> it.include(new String[]{"*"}))});
                xcodeTarget.getSources().from(new Object[]{project.fileTree((Object)"src/main/objc", it -> it.include(new String[]{"*"}))});
                xcodeTarget.getSources().from(new Object[]{this.getProviders().provider(() -> {
                    try {
                        final ArrayList result = new ArrayList();
                        Files.walkFileTree(project.file((Object)"src/main/resources").toPath(), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                                if (path.equals(project.file((Object)"src/main/resources").toPath())) {
                                    return FileVisitResult.CONTINUE;
                                }
                                if (path.getFileName().toString().endsWith(".lproj")) {
                                    return FileVisitResult.CONTINUE;
                                }
                                result.add(path);
                                return FileVisitResult.SKIP_SUBTREE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                                result.add(path);
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFileFailed(Path path, IOException e) throws IOException {
                                return FileVisitResult.TERMINATE;
                            }

                            @Override
                            public FileVisitResult postVisitDirectory(Path path, IOException e) throws IOException {
                                return FileVisitResult.CONTINUE;
                            }
                        });
                        return result;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                })});
            });
            project.getPluginManager().withPlugin("dev.nokee.objective-c-xctest-test-suite", appliedPlugin -> {
                xcodeProject.getTargets().register(moduleName + "UnitTest", xcodeTarget -> {
                    xcodeTarget.getProductName().set((Object)(moduleName + "UnitTest"));
                    xcodeTarget.getProductReference().set((Object)(moduleName + "UnitTest.xctest"));
                    xcodeTarget.getProductType().set((Object)XcodeIdeProductTypes.UNIT_TEST);
                    xcodeTarget.getBuildConfigurations().register("Default", xcodeConfiguration -> {
                        xcodeConfiguration.getProductLocation().set(this.getTasks().named("createUnitTestXCTestBundle", CreateIosXCTestBundleTask.class).flatMap(CreateIosXCTestBundleTask::getXCTestBundle));
                        xcodeConfiguration.getBuildSettings().put("BUNDLE_LOADER", "$(TEST_HOST)").put("INFOPLIST_FILE", "src/unitTest/resources/Info.plist").put("IPHONEOS_DEPLOYMENT_TARGET", 13.2).put("PRODUCT_BUNDLE_IDENTIFIER", project.getGroup().toString() + "." + moduleName + "UnitTest").put("PRODUCT_NAME", "$(TARGET_NAME)").put("TARGETED_DEVICE_FAMILY", "1,2").put("SDKROOT", "iphoneos").put("USER_HEADER_SEARCH_PATHS", (Provider<Object>)this.getProviders().provider(this::getHeaderSearchPaths)).put("FRAMEWORK_SEARCH_PATHS", (Provider<Object>)this.getProviders().provider(this::getXCTestFrameworkPaths)).put("COMPILER_INDEX_STORE_ENABLE", "YES").put("USE_HEADERMAP", "NO");
                    });
                    xcodeTarget.getSources().from(new Object[]{project.fileTree((Object)"src/unitTest/headers", it -> it.include(new String[]{"*"}))});
                    xcodeTarget.getSources().from(new Object[]{project.fileTree((Object)"src/unitTest/objc", it -> it.include(new String[]{"*"}))});
                    xcodeTarget.getSources().from(new Object[]{project.fileTree((Object)"src/unitTest/resources", it -> it.include(new String[]{"*"}))});
                });
                xcodeProject.getTargets().register(moduleName + "UiTest", xcodeTarget -> {
                    xcodeTarget.getProductName().set((Object)(moduleName + "UiTest"));
                    xcodeTarget.getProductReference().set((Object)(moduleName + "UiTest.xctest"));
                    xcodeTarget.getProductType().set((Object)XcodeIdeProductTypes.UI_TEST);
                    xcodeTarget.getBuildConfigurations().register("Default", xcodeConfiguration -> {
                        xcodeConfiguration.getProductLocation().set(this.getTasks().named("createUiTestLauncherApplicationBundle", CreateIosApplicationBundleTask.class).flatMap(CreateIosApplicationBundleTask::getApplicationBundle));
                        xcodeConfiguration.getBuildSettings().put("BUNDLE_LOADER", "$(TEST_HOST)").put("INFOPLIST_FILE", "src/uiTest/resources/Info.plist").put("IPHONEOS_DEPLOYMENT_TARGET", 13.2).put("PRODUCT_BUNDLE_IDENTIFIER", project.getGroup().toString() + "." + moduleName + "UiTest").put("PRODUCT_NAME", "$(TARGET_NAME)").put("TARGETED_DEVICE_FAMILY", "1,2").put("SDKROOT", "iphoneos").put("USER_HEADER_SEARCH_PATHS", (Provider<Object>)this.getProviders().provider(this::getHeaderSearchPaths)).put("FRAMEWORK_SEARCH_PATHS", (Provider<Object>)this.getProviders().provider(this::getXCTestFrameworkPaths)).put("COMPILER_INDEX_STORE_ENABLE", "YES").put("USE_HEADERMAP", "NO").put("TEST_TARGET_NAME", moduleName);
                    });
                    xcodeTarget.getSources().from(new Object[]{project.fileTree((Object)"src/uiTest/headers", it -> it.include(new String[]{"*"}))});
                    xcodeTarget.getSources().from(new Object[]{project.fileTree((Object)"src/uiTest/objc", it -> it.include(new String[]{"*"}))});
                    xcodeTarget.getSources().from(new Object[]{project.fileTree((Object)"src/uiTest/resources", it -> it.include(new String[]{"*"}))});
                });
            });
        });
        project.getPluginManager().withPlugin("dev.nokee.objective-c-xctest-test-suite", appliedPlugin -> {
            this.getTasks().register("syncUiTestRunner", SyncXcodeIdeProduct.class, task -> {
                task.getProductLocation().set(this.getTasks().named("createUiTestLauncherApplicationBundle", CreateIosApplicationBundleTask.class).flatMap(CreateIosApplicationBundleTask::getApplicationBundle));
                task.getDestinationLocation().set(this.getObjects().directoryProperty().fileValue(new File(new XcodeIdePropertyAdapter(project).getBuiltProductsDir())).file(moduleName + "UiTest-Runner.app"));
            });
            this.getTasks().withType(SyncXcodeIdeProduct.class).configureEach(task -> {
                if (task.getName().contains(moduleName + "UiTest")) {
                    task.dependsOn(new Object[]{"syncUiTestRunner"});
                    task.dependsOn(new Object[]{task.getName().replace("UiTest", "")});
                }
                if (task.getName().contains(moduleName + "UnitTest") || task.getName().contains(moduleName + "UiTest")) {
                    task.doLast((Action)new Action<Task>(){

                        public void execute(Task task) {
                            XcodeIdePlugin.XcodeIdeRequest request = XcodeIdePlugin.XcodeIdeRequest.of(task.getName());
                            ConfigurableFileCollection sources = ((XcodeIdeTarget)((XcodeIdeProject)((XcodeIdeProjectExtension)project.getExtensions().getByType(XcodeIdeProjectExtension.class)).getProjects().getByName(request.getProjectName())).getTargets().getByName(request.getTargetName())).getSources();
                            for (String arch : StringUtils.split((String)System.getenv("ARCHS"), (char)' ')) {
                                String objectFileDir = System.getenv("OBJECT_FILE_DIR");
                                String productName = System.getenv("PRODUCT_NAME");
                                File dependencyInfo = new File(objectFileDir + "-normal/" + arch, productName + "_dependency_info.dat");
                                dependencyInfo.getParentFile().mkdirs();
                                try {
                                    FileUtils.writeByteArrayToFile((File)dependencyInfo, (byte[])new byte[]{0, 49, 0});
                                    for (File file : sources) {
                                        new File(objectFileDir + "-normal/" + arch, FilenameUtils.removeExtension((String)file.getName()) + ".d").createNewFile();
                                    }
                                }
                                catch (IOException e) {
                                    throw new UncheckedIOException(e);
                                }
                            }
                        }
                    });
                }
            });
        });
    }

    @Inject
    protected abstract TaskContainer getTasks();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract ObjectFactory getObjects();

    private String getHeaderSearchPaths() {
        return this.getTasks().withType(ObjectiveCCompile.class).stream().flatMap(it -> Stream.concat(it.getIncludes().getFiles().stream(), it.getSystemIncludes().getFiles().stream().filter(f -> !f.getAbsolutePath().contains("/MacOSX.platform/")))).map(File::getAbsolutePath).collect(Collectors.joining(" "));
    }

    private String getFrameworkPaths() {
        try {
            Process process = new ProcessBuilder("xcrun", "--sdk", "iphonesimulator", "--show-sdk-path").start();
            process.waitFor();
            return IOUtils.toString((InputStream)process.getInputStream(), (Charset)Charset.defaultCharset()).trim() + "/System/Library/Frameworks";
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private String getXCTestFrameworkPaths() {
        try {
            Process process = new ProcessBuilder("xcrun", "--sdk", "iphonesimulator", "--show-sdk-platform-path").start();
            process.waitFor();
            return this.getFrameworkPaths() + " " + IOUtils.toString((InputStream)process.getInputStream(), (Charset)Charset.defaultCharset()).trim() + "/Developer/Library/Frameworks";
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private String toSpaceSeparatedList(Set<FileSystemLocation> paths) {
        return paths.stream().map(location -> location.getAsFile().getAbsolutePath()).collect(Collectors.joining(" "));
    }
}

