/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.ide.xcode.internal;

import java.util.Arrays;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.util.GUtil;

public class XcodeIdePropertyAdapter {
    private final Project project;

    public XcodeIdePropertyAdapter(Project project) {
        this.project = project;
    }

    public String getAction() {
        return this.getXcodeProperty("ACTION");
    }

    public String getProductName() {
        return this.getXcodeProperty("PRODUCT_NAME");
    }

    public String getConfiguration() {
        return this.getXcodeProperty("CONFIGURATION");
    }

    public String getBuiltProductsDir() {
        return this.getXcodeProperty("BUILT_PRODUCTS_DIR");
    }

    public String getProjectName() {
        return this.getXcodeProperty("PROJECT_NAME");
    }

    public String getTargetName() {
        return this.getXcodeProperty("TARGET_NAME");
    }

    private String getXcodeProperty(String name) {
        return String.valueOf(GUtil.elvis((Object)this.project.findProperty(XcodeIdePropertyAdapter.prefixName(name)), (Object)""));
    }

    public static List<String> getAdapterCommandLine() {
        return Arrays.asList(XcodeIdePropertyAdapter.toGradleProperty("ACTION"), XcodeIdePropertyAdapter.toGradleProperty("PRODUCT_NAME"), XcodeIdePropertyAdapter.toGradleProperty("CONFIGURATION"), XcodeIdePropertyAdapter.toGradleProperty("BUILT_PRODUCTS_DIR"), XcodeIdePropertyAdapter.toGradleProperty("PROJECT_NAME"), XcodeIdePropertyAdapter.toGradleProperty("TARGET_NAME"));
    }

    private static String toGradleProperty(String source) {
        return "-P" + XcodeIdePropertyAdapter.prefixName(source) + "=\"${" + source + "}\"";
    }

    private static String prefixName(String source) {
        return "dev.nokee.internal.xcode.bridge." + source;
    }
}

