/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.ide.xcode.internal;

import dev.nokee.ide.xcode.XcodeIdeBuildConfiguration;
import dev.nokee.ide.xcode.XcodeIdeTarget;
import dev.nokee.ide.xcode.internal.DefaultXcodeIdeBuildConfiguration;
import javax.inject.Inject;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.model.ObjectFactory;

public abstract class DefaultXcodeIdeTarget
implements XcodeIdeTarget {
    private final String name;
    private final NamedDomainObjectContainer<XcodeIdeBuildConfiguration> buildConfigurations;

    @Inject
    public DefaultXcodeIdeTarget(String name) {
        this.name = name;
        this.buildConfigurations = this.getObjects().domainObjectContainer(XcodeIdeBuildConfiguration.class, this::newBuildConfiguration);
        this.getProductName().convention(this.getProductReference().map(this::toProductName));
    }

    private String toProductName(String filename) {
        String result = FilenameUtils.removeExtension((String)filename);
        if (filename.startsWith("lib")) {
            result = result.substring(3);
        }
        return result;
    }

    @Inject
    protected abstract ObjectFactory getObjects();

    @Override
    public void buildConfigurations(@NonNull Action<? super NamedDomainObjectContainer<XcodeIdeBuildConfiguration>> action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        action.execute(this.buildConfigurations);
    }

    private XcodeIdeBuildConfiguration newBuildConfiguration(String name) {
        return (XcodeIdeBuildConfiguration)this.getObjects().newInstance(DefaultXcodeIdeBuildConfiguration.class, new Object[]{name});
    }

    @Override
    public XcodeIdeTarget getIdeTarget() {
        return this;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public NamedDomainObjectContainer<XcodeIdeBuildConfiguration> getBuildConfigurations() {
        return this.buildConfigurations;
    }
}

