/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.ide.xcode.internal.xcodeproj;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import dev.nokee.ide.xcode.XcodeIdeProductType;
import dev.nokee.ide.xcode.internal.xcodeproj.PBXBuildPhase;
import dev.nokee.ide.xcode.internal.xcodeproj.PBXFileReference;
import dev.nokee.ide.xcode.internal.xcodeproj.PBXProjectItem;
import dev.nokee.ide.xcode.internal.xcodeproj.XCConfigurationList;
import dev.nokee.ide.xcode.internal.xcodeproj.XcodeprojSerializer;
import java.util.List;
import javax.annotation.Nullable;

public abstract class PBXTarget
extends PBXProjectItem {
    private final String name;
    private final XcodeIdeProductType productType;
    private final List<PBXBuildPhase> buildPhases;
    private final XCConfigurationList buildConfigurationList;
    @Nullable
    private String productName;
    @Nullable
    private PBXFileReference productReference;

    public PBXTarget(String name, XcodeIdeProductType productType) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.productType = (XcodeIdeProductType)Preconditions.checkNotNull((Object)productType);
        this.buildPhases = Lists.newArrayList();
        this.buildConfigurationList = new XCConfigurationList();
    }

    public String getName() {
        return this.name;
    }

    public XcodeIdeProductType getProductType() {
        return this.productType;
    }

    public List<PBXBuildPhase> getBuildPhases() {
        return this.buildPhases;
    }

    public XCConfigurationList getBuildConfigurationList() {
        return this.buildConfigurationList;
    }

    @Nullable
    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    @Nullable
    public PBXFileReference getProductReference() {
        return this.productReference;
    }

    public void setProductReference(PBXFileReference v) {
        this.productReference = v;
    }

    @Override
    public String isa() {
        return "PBXTarget";
    }

    @Override
    public int stableHash() {
        return this.name.hashCode();
    }

    @Override
    public void serializeInto(XcodeprojSerializer s) {
        super.serializeInto(s);
        s.addField("name", this.name);
        if (this.productType != null) {
            s.addField("productType", this.productType.toString());
        }
        if (this.productName != null) {
            s.addField("productName", this.productName);
        }
        if (this.productReference != null) {
            s.addField("productReference", this.productReference);
        }
        s.addField("buildPhases", this.buildPhases);
        if (this.buildConfigurationList != null) {
            s.addField("buildConfigurationList", this.buildConfigurationList);
        }
    }
}

