/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.ide.xcode.internal.tasks;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;

public abstract class SyncXcodeIdeProduct
extends DefaultTask {
    @InputFiles
    public abstract Property<FileSystemLocation> getProductLocation();

    @Internal
    public abstract Property<FileSystemLocation> getDestinationLocation();

    @OutputFiles
    protected FileCollection getOutputFiles() {
        return this.getObjects().fileCollection().from(new Object[]{this.getDestinationLocation().map(location -> {
            File locationAsFile = location.getAsFile();
            if (locationAsFile.isDirectory()) {
                return this.getObjects().fileTree().setDir((Object)locationAsFile).matching(it -> it.include(new String[]{"**/*"}));
            }
            return locationAsFile;
        })});
    }

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract FileSystemOperations getFileOperations();

    @TaskAction
    private void sync() throws IOException {
        File productLocation = ((FileSystemLocation)this.getProductLocation().get()).getAsFile();
        if (productLocation.isDirectory()) {
            this.getFileOperations().sync(spec -> {
                spec.from(new Object[]{this.getProductLocation()});
                spec.into(this.getDestinationLocation());
            });
        } else {
            FileUtils.copyFile((File)productLocation, (File)((FileSystemLocation)this.getDestinationLocation().get()).getAsFile());
        }
    }
}

