/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.ide.xcode.internal.tasks;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public abstract class GenerateXcodeIdeWorkspaceTask
extends DefaultTask {
    @InputFiles
    public abstract SetProperty<FileSystemLocation> getProjectLocations();

    @OutputDirectory
    public abstract Property<FileSystemLocation> getWorkspaceLocation();

    @TaskAction
    private void generate() throws IOException {
        File workspaceDirectory = ((FileSystemLocation)this.getWorkspaceLocation().get()).getAsFile();
        FileUtils.deleteDirectory((File)workspaceDirectory);
        workspaceDirectory.mkdirs();
        List<Workspace.FileRef> fileReferences = ((Set)this.getProjectLocations().get()).stream().map(it -> new Workspace.FileRef(it.getAsFile().getAbsolutePath())).collect(Collectors.toList());
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
        xmlMapper.writeValue(new File(workspaceDirectory, "contents.xcworkspacedata"), (Object)new Workspace(fileReferences));
        File workspaceSettingsFile = new File(workspaceDirectory, "xcshareddata/WorkspaceSettings.xcsettings");
        workspaceSettingsFile.getParentFile().mkdirs();
        FileUtils.writeStringToFile((File)workspaceSettingsFile, (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">\n<dict>\n\t<key>IDEWorkspaceSharedSettings_AutocreateContextsIfNeeded</key>\n\t<false/>\n</dict>\n</plist>", (Charset)Charset.defaultCharset());
    }

    private static final class Workspace {
        @JacksonXmlElementWrapper(useWrapping=false)
        @JacksonXmlProperty(localName="FileRef")
        @NonNull
        private final Collection<FileRef> fileRef;

        @JacksonXmlProperty(isAttribute=true)
        public String getVersion() {
            return "1.0";
        }

        public Workspace(@NonNull Collection<FileRef> fileRef) {
            if (fileRef == null) {
                throw new NullPointerException("fileRef is marked non-null but is null");
            }
            this.fileRef = fileRef;
        }

        @NonNull
        public Collection<FileRef> getFileRef() {
            return this.fileRef;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Workspace)) {
                return false;
            }
            Workspace other = (Workspace)o;
            Collection<FileRef> this$fileRef = this.getFileRef();
            Collection<FileRef> other$fileRef = other.getFileRef();
            return !(this$fileRef == null ? other$fileRef != null : !((Object)this$fileRef).equals(other$fileRef));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<FileRef> $fileRef = this.getFileRef();
            result = result * 59 + ($fileRef == null ? 43 : ((Object)$fileRef).hashCode());
            return result;
        }

        public String toString() {
            return "GenerateXcodeIdeWorkspaceTask.Workspace(fileRef=" + this.getFileRef() + ")";
        }

        static final class FileRef {
            @JacksonXmlProperty(isAttribute=true)
            private final String location;

            public FileRef(String location) {
                this.location = "absolute:" + location;
            }

            public String getLocation() {
                return this.location;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FileRef)) {
                    return false;
                }
                FileRef other = (FileRef)o;
                String this$location = this.getLocation();
                String other$location = other.getLocation();
                return !(this$location == null ? other$location != null : !this$location.equals(other$location));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $location = this.getLocation();
                result = result * 59 + ($location == null ? 43 : $location.hashCode());
                return result;
            }

            public String toString() {
                return "GenerateXcodeIdeWorkspaceTask.Workspace.FileRef(location=" + this.getLocation() + ")";
            }
        }
    }
}

