/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.ide.xcode.internal;

import com.google.common.collect.ImmutableSet;
import dev.nokee.ide.xcode.XcodeIdeProject;
import dev.nokee.ide.xcode.XcodeIdeTarget;
import dev.nokee.ide.xcode.internal.DefaultXcodeIdeTarget;
import dev.nokee.ide.xcode.internal.tasks.GenerateXcodeIdeProjectTask;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Buildable;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Task;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskProvider;

public abstract class DefaultXcodeIdeProject
implements XcodeIdeProject,
Buildable {
    private final String name;
    private final TaskProvider<GenerateXcodeIdeProjectTask> generatorTask;
    private final NamedDomainObjectContainer<XcodeIdeTarget> targets;

    @Inject
    public DefaultXcodeIdeProject(String name) {
        this.name = name;
        this.targets = this.getObjects().domainObjectContainer(XcodeIdeTarget.class, this::newTarget);
        this.generatorTask = this.getTasks().register(name + "XcodeProject", GenerateXcodeIdeProjectTask.class, new Object[]{this});
    }

    @Inject
    protected abstract TaskContainer getTasks();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Override
    public Provider<FileSystemLocation> getLocation() {
        return this.generatorTask.flatMap(GenerateXcodeIdeProjectTask::getProjectLocation);
    }

    public TaskDependency getBuildDependencies() {
        return new TaskDependency(){

            public Set<? extends Task> getDependencies(@Nullable Task task) {
                return ImmutableSet.of((Object)DefaultXcodeIdeProject.this.generatorTask.get());
            }
        };
    }

    @Override
    public void targets(Action<? super NamedDomainObjectContainer<XcodeIdeTarget>> action) {
        action.execute(this.targets);
    }

    private XcodeIdeTarget newTarget(String name) {
        return (XcodeIdeTarget)this.getObjects().newInstance(DefaultXcodeIdeTarget.class, new Object[]{name});
    }

    public String getName() {
        return this.name;
    }

    public TaskProvider<GenerateXcodeIdeProjectTask> getGeneratorTask() {
        return this.generatorTask;
    }

    @Override
    public NamedDomainObjectContainer<XcodeIdeTarget> getTargets() {
        return this.targets;
    }
}

