/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.core.exec;

import dev.nokee.core.exec.CommandLineToolExecutionEngine;
import dev.nokee.core.exec.CommandLineToolExecutionHandle;
import dev.nokee.core.exec.CommandLineToolInvocation;
import dev.nokee.core.exec.ExecException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import javax.inject.Inject;
import org.apache.commons.io.output.TeeOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.process.ExecOperations;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

public abstract class GradleWorkerExecutorEngine
implements CommandLineToolExecutionEngine<Handle> {
    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @Override
    public Handle submit(CommandLineToolInvocation invocation) {
        WorkQueue workQueue = this.getWorkerExecutor().noIsolation();
        workQueue.submit(GradleWorkerExecutorEngineWorkAction.class, it -> {
            it.getCommandLine().add((Object)invocation.getTool().getExecutable());
            it.getCommandLine().addAll(invocation.getArguments().get());
            it.getStandardStreamFile().set((File)invocation.getStandardStreamFile().orElse(null));
        });
        return new Handle(workQueue);
    }

    public static abstract class GradleWorkerExecutorEngineWorkAction
    implements WorkAction<GradleWorkerExecutorEngineWorkParameters> {
        @Inject
        protected abstract ExecOperations getExecOperations();

        public void execute() {
            ByteArrayOutputStream logs = new ByteArrayOutputStream();
            try {
                this.getExecOperations().exec(spec -> {
                    spec.commandLine((Iterable)((GradleWorkerExecutorEngineWorkParameters)this.getParameters()).getCommandLine().get());
                    ByteArrayOutputStream outStream = logs;
                    if (((GradleWorkerExecutorEngineWorkParameters)this.getParameters()).getStandardStreamFile().isPresent()) {
                        try {
                            outStream = new TeeOutputStream((OutputStream)new FileOutputStream(((RegularFile)((GradleWorkerExecutorEngineWorkParameters)this.getParameters()).getStandardStreamFile().get()).getAsFile(), true), (OutputStream)outStream);
                        }
                        catch (FileNotFoundException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    spec.setStandardOutput((OutputStream)outStream);
                    spec.setErrorOutput((OutputStream)outStream);
                });
            }
            catch (GradleException e) {
                throw new ExecException("An error happen while executing command, here is the output:\n" + logs.toString());
            }
        }
    }

    public static interface GradleWorkerExecutorEngineWorkParameters
    extends WorkParameters {
        public ListProperty<String> getCommandLine();

        public RegularFileProperty getStandardStreamFile();
    }

    public static class Handle
    implements CommandLineToolExecutionHandle {
        private final WorkQueue workQueue;

        public void await() {
            this.workQueue.await();
        }

        public Handle(WorkQueue workQueue) {
            this.workQueue = workQueue;
        }
    }
}

