/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.commons.names;

import dev.nokee.commons.names.DefaultFullyQualifiedName;
import dev.nokee.commons.names.ElementName;
import dev.nokee.commons.names.FullyQualifiedName;
import dev.nokee.commons.names.NameBuilder;
import dev.nokee.commons.names.NameSupport;
import dev.nokee.commons.names.NamingScheme;
import dev.nokee.commons.names.Preconditions;
import dev.nokee.commons.names.Prop;
import dev.nokee.commons.names.Qualifier;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class TaskName
extends NameSupport<TaskName>
implements ElementName {
    private final NamingScheme scheme = NamingScheme.of(NamingScheme.property("verb"), NamingScheme.qualifier(), NamingScheme.property("object"));
    @Nullable
    private final String verb;
    @Nullable
    private final String object;

    private TaskName(@Nullable String verb, @Nullable String object) {
        assert (verb != null || object != null);
        this.verb = verb;
        this.object = object;
    }

    @Override
    void init(Prop.Builder<TaskName> builder) {
        builder.with("verb", this::withVerb, () -> this.getVerb().orElse(null)).with("object", this::withObject, () -> this.getObject().orElse(null));
    }

    public Optional<String> getVerb() {
        return Optional.ofNullable(this.verb);
    }

    public TaskName withVerb(String verb) {
        return new TaskName(verb, this.object);
    }

    public Optional<String> getObject() {
        return Optional.ofNullable(this.object);
    }

    public TaskName withObject(@Nullable String object) {
        return new TaskName(this.verb, object);
    }

    @Override
    public FullyQualifiedName qualifiedBy(Qualifier qualifier) {
        return new DefaultFullyQualifiedName(qualifier, this, this.scheme);
    }

    public static TaskName of(String taskName) {
        Objects.requireNonNull(taskName);
        Preconditions.checkArgument(!taskName.trim().isEmpty(), "'taskName' must not be blank", new Object[0]);
        Preconditions.checkArgument(Character.isLowerCase(taskName.charAt(0)), "'taskName' must start with a lowercase letter", new Object[0]);
        return new TaskName(taskName, null);
    }

    public static TaskName of(String verb, String object) {
        Objects.requireNonNull(verb);
        Objects.requireNonNull(object);
        Preconditions.checkArgument(!verb.trim().isEmpty(), "'verb' must not be blank", new Object[0]);
        Preconditions.checkArgument(!object.trim().isEmpty(), "'object' must not be blank", new Object[0]);
        Preconditions.checkArgument(Character.isLowerCase(verb.charAt(0)), "'verb' must start with a lowercase letter", new Object[0]);
        Preconditions.checkArgument(Character.isLowerCase(object.charAt(0)), "'object' must start with a lowercase letter", new Object[0]);
        return new TaskName(verb, object);
    }

    @Deprecated
    public static String taskName(String verb, String object) {
        return TaskName.of(verb, object).toString();
    }

    @Override
    public String toString() {
        return this.scheme.format(this).using(NameBuilder::toStringCase);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Builder() {
        }

        public TaskName forObject(String object) {
            Objects.requireNonNull(object);
            return new TaskName(null, object);
        }
    }
}

