/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.commons.names;

import dev.nokee.commons.names.Name;
import dev.nokee.commons.names.NameSupport;
import dev.nokee.commons.names.Prop;
import dev.nokee.commons.names.QualifiedName;
import dev.nokee.commons.names.StringUtils;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.publish.Publication;
import org.gradle.api.specs.Spec;

public final class PublishingTaskNames {
    private static final PublishingTaskNames INSTANCE = new PublishingTaskNames();

    ForPublicationBuilder<PublishingTaskName> generateMetadataFileTaskName() {
        return publication -> new GenerateMetadataFileTaskName(publication.getName());
    }

    public static String generateMetadataFileTaskName(Publication publication) {
        return INSTANCE.generateMetadataFileTaskName().forPublication(publication).toString();
    }

    ForPublicationBuilder<PublishingTaskName> generatePomFileTaskName() {
        return publication -> new GeneratePomFileTaskName(publication.getName());
    }

    public static String generatePomFileTaskName(Publication publication) {
        return INSTANCE.generatePomFileTaskName().forPublication(publication).toString();
    }

    ForPublicationBuilder<PublishingTaskName> generateDescriptorFileTaskName() {
        return publication -> new GenerateDescriptorFileTaskName(publication.getName());
    }

    public static String generateDescriptorFileTaskName(Publication publication) {
        return INSTANCE.generateDescriptorFileTaskName().forPublication(publication).toString();
    }

    PublishTaskName publishTaskName() {
        return new PublishTaskName();
    }

    ToRepositoryBuilder publishTaskName(Publication publication) {
        return new PublishTaskNameBuilder(publication.getName());
    }

    public static String publishPublicationToRepositoryTaskName(Publication publication, ArtifactRepository repository) {
        return INSTANCE.publishTaskName(publication).to(repository).toString();
    }

    public static Spec<String> publishPublicationToAnyRepositories(Publication publication) {
        return INSTANCE.publishTaskName(publication).toAnyRepositories();
    }

    static interface ForPublicationBuilder<T extends PublishingTaskName> {
        public T forPublication(Publication var1);
    }

    static interface PublishingTaskName
    extends Name {
    }

    static final class PublishTaskName
    extends NameSupport<PublishTaskName>
    implements ToRepositoryBuilder,
    Name {
        PublishTaskName() {
        }

        @Override
        public ToMavenLocalTaskName toMavenLocal() {
            return new PublishToMavenLocalTaskName();
        }

        @Override
        public Spec<String> toAnyRepositories() {
            return it -> it.startsWith("publishAllPublicationsTo");
        }

        @Override
        public ToRepositoryTaskName to(ArtifactRepository repository) {
            return new PublishAllPublicationsToRepositoryTaskName(repository.getName());
        }

        @Override
        public String toString() {
            return "publish";
        }
    }

    private static final class PublishTaskNameBuilder
    implements ToRepositoryBuilder {
        private final String publicationName;

        private PublishTaskNameBuilder(String publicationName) {
            this.publicationName = publicationName;
        }

        @Override
        public ToMavenLocalTaskName toMavenLocal() {
            return new PublishPublicationToMavenLocalTaskName(this.publicationName);
        }

        @Override
        public Spec<String> toAnyRepositories() {
            return it -> it.startsWith("publish" + StringUtils.capitalize(this.publicationName) + "PublicationTo");
        }

        @Override
        public ToRepositoryTaskName to(ArtifactRepository repository) {
            return new PublishPublicationToRepositoryTaskName(this.publicationName, repository.getName());
        }
    }

    static interface ToRepositoryBuilder {
        public ToMavenLocalTaskName toMavenLocal();

        public Spec<String> toAnyRepositories();

        public ToRepositoryTaskName to(ArtifactRepository var1);
    }

    static interface ToRepositoryTaskName
    extends Name {
    }

    private static final class GenerateDescriptorFileTaskName
    extends NameSupport<GenerateDescriptorFileTaskName>
    implements PublishingTaskName,
    QualifiedName {
        private final String publicationName;

        private GenerateDescriptorFileTaskName(String publicationName) {
            this.publicationName = publicationName;
        }

        @Override
        void init(Prop.Builder<GenerateDescriptorFileTaskName> builder) {
            builder.with("publicationName", this::withPublicationName, this::getPublicationName);
        }

        public GenerateDescriptorFileTaskName withPublicationName(String publicationName) {
            return new GenerateDescriptorFileTaskName(publicationName);
        }

        public String getPublicationName() {
            return this.publicationName;
        }

        @Override
        public String toString() {
            return "generateDescriptorFileFor" + StringUtils.capitalize(this.publicationName) + "Publication";
        }
    }

    private static final class GeneratePomFileTaskName
    extends NameSupport<GeneratePomFileTaskName>
    implements PublishingTaskName,
    QualifiedName {
        private final String publicationName;

        private GeneratePomFileTaskName(String publicationName) {
            this.publicationName = publicationName;
        }

        @Override
        void init(Prop.Builder<GeneratePomFileTaskName> builder) {
            builder.with("publicationName", this::withPublicationName, this::getPublicationName);
        }

        public GeneratePomFileTaskName withPublicationName(String publicationName) {
            return new GeneratePomFileTaskName(publicationName);
        }

        public String getPublicationName() {
            return this.publicationName;
        }

        @Override
        public String toString() {
            return "generatePomFileFor" + StringUtils.capitalize(this.publicationName) + "Publication";
        }
    }

    private static final class GenerateMetadataFileTaskName
    extends NameSupport<GenerateMetadataFileTaskName>
    implements PublishingTaskName,
    QualifiedName {
        private final String publicationName;

        private GenerateMetadataFileTaskName(String publicationName) {
            this.publicationName = publicationName;
        }

        @Override
        void init(Prop.Builder<GenerateMetadataFileTaskName> builder) {
            builder.with("publicationName", this::withPublicationName, this::getPublicationName);
        }

        public GenerateMetadataFileTaskName withPublicationName(String publicationName) {
            return new GenerateMetadataFileTaskName(publicationName);
        }

        public String getPublicationName() {
            return this.publicationName;
        }

        @Override
        public String toString() {
            return "generateMetadataFileFor" + StringUtils.capitalize(this.publicationName) + "Publication";
        }
    }

    private static final class PublishPublicationToRepositoryTaskName
    extends NameSupport<PublishPublicationToRepositoryTaskName>
    implements ToRepositoryTaskName,
    QualifiedName {
        private final String publicationName;
        private final String repositoryName;

        private PublishPublicationToRepositoryTaskName(String publicationName, String repositoryName) {
            this.publicationName = publicationName;
            this.repositoryName = repositoryName;
        }

        @Override
        void init(Prop.Builder<PublishPublicationToRepositoryTaskName> builder) {
            builder.with("publicationName", this::withPublicationName, this::getPublicationName).with("repositoryName", this::withRepositoryName, this::getRepositoryName);
        }

        public String getPublicationName() {
            return this.publicationName;
        }

        public PublishPublicationToRepositoryTaskName withPublicationName(String publicationName) {
            return new PublishPublicationToRepositoryTaskName(publicationName, this.repositoryName);
        }

        public String getRepositoryName() {
            return this.repositoryName;
        }

        public PublishPublicationToRepositoryTaskName withRepositoryName(String repositoryName) {
            return new PublishPublicationToRepositoryTaskName(this.publicationName, repositoryName);
        }

        @Override
        public String toString() {
            return "publish" + StringUtils.capitalize(this.publicationName) + "PublicationTo" + StringUtils.capitalize(this.repositoryName) + "Repository";
        }
    }

    private static final class PublishPublicationToMavenLocalTaskName
    extends NameSupport<PublishPublicationToMavenLocalTaskName>
    implements ToMavenLocalTaskName,
    QualifiedName {
        private final String publicationName;

        private PublishPublicationToMavenLocalTaskName(String publicationName) {
            this.publicationName = publicationName;
        }

        @Override
        void init(Prop.Builder<PublishPublicationToMavenLocalTaskName> builder) {
            builder.with("publicationName", this::withPublicationName, this::getPublicationName);
        }

        public String getPublicationName() {
            return this.publicationName;
        }

        public PublishPublicationToMavenLocalTaskName withPublicationName(String publicationName) {
            return new PublishPublicationToMavenLocalTaskName(publicationName);
        }

        @Override
        public String toString() {
            return "publish" + StringUtils.capitalize(this.publicationName) + "PublicationToMavenLocal";
        }
    }

    private static final class PublishAllPublicationsToRepositoryTaskName
    extends NameSupport<PublishAllPublicationsToRepositoryTaskName>
    implements ToRepositoryTaskName,
    QualifiedName {
        private final String repositoryName;

        private PublishAllPublicationsToRepositoryTaskName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        void init(Prop.Builder<PublishAllPublicationsToRepositoryTaskName> builder) {
            builder.with("repositoryName", this::withRepositoryName, this::getRepositoryName);
        }

        public String getRepositoryName() {
            return this.repositoryName;
        }

        public PublishAllPublicationsToRepositoryTaskName withRepositoryName(String repositoryName) {
            return new PublishAllPublicationsToRepositoryTaskName(repositoryName);
        }

        @Override
        public String toString() {
            return "publishAllPublicationsTo" + StringUtils.capitalize(this.repositoryName) + "Repository";
        }
    }

    static final class PublishToMavenLocalTaskName
    extends NameSupport<PublishToMavenLocalTaskName>
    implements ToMavenLocalTaskName {
        PublishToMavenLocalTaskName() {
        }

        @Override
        public String toString() {
            return "publishToMavenLocal";
        }
    }

    static interface ToMavenLocalTaskName
    extends Name {
    }
}

