/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.commons.names;

import dev.nokee.commons.names.IHasProp;
import dev.nokee.commons.names.IParameterizedObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

final class Prop<OUT> {
    private final Map<String, Function<Object, OUT>> map = new HashMap<String, Function<Object, OUT>>();
    private final Class<OUT> outType;
    private final List<Consumer<? super Builder<OUT>>> builders;
    private final Map<String, Supplier<Object>> props = new HashMap<String, Supplier<Object>>();

    public Prop(Class<OUT> outType, Map<String, Function<Object, OUT>> map, List<Consumer<? super Builder<OUT>>> builders, Map<String, Supplier<Object>> props) {
        this.outType = outType;
        this.builders = builders;
        this.map.putAll(map);
        this.props.putAll(props);
    }

    public OUT with(String propName, Object value) {
        Iterator<Consumer<Builder<OUT>>> iter = this.builders.iterator();
        while (!this.map.containsKey(propName) && iter.hasNext()) {
            Consumer<Builder<OUT>> it = iter.next();
            iter.remove();
            Builder<OUT> builder = new Builder<OUT>(this.outType);
            it.accept(builder);
            this.map.putAll(builder.build().map);
        }
        return Objects.requireNonNull(this.map.get(propName), "no prop '" + propName + "'").apply(value);
    }

    public Object get(String propName) {
        return Optional.ofNullable(this.props.get(propName)).map(Supplier::get).orElse(null);
    }

    public Set<String> names() {
        Iterator<Consumer<Builder<OUT>>> iter = this.builders.iterator();
        while (iter.hasNext()) {
            Consumer<Builder<OUT>> it = iter.next();
            iter.remove();
            Builder<OUT> builder = new Builder<OUT>(this.outType);
            it.accept(builder);
            this.map.putAll(builder.build().map);
        }
        return this.map.keySet();
    }

    public static class Builder<OUT> {
        final Map<String, Function<Object, OUT>> map = new HashMap<String, Function<Object, OUT>>();
        final Map<String, Supplier<Object>> props = new HashMap<String, Supplier<Object>>();
        private final List<Consumer<? super Builder<OUT>>> builders = new ArrayList<Consumer<? super Builder<OUT>>>();
        private final Class<OUT> outType;

        public Builder(Class<OUT> outType) {
            this.outType = outType;
        }

        public <IN> Builder<OUT> with(String propName, Function<? super IN, ? extends OUT> method, Supplier<? extends IN> getter) {
            this.map.put(propName, method);
            this.props.put(propName, getter);
            Object obj = getter.get();
            if (obj instanceof IParameterizedObject) {
                for (String propName2 : ((IParameterizedObject)obj).propSet()) {
                    this.map.computeIfAbsent(propName2, n -> it -> method.apply((Object)((IParameterizedObject)obj).with((String)n, it)));
                }
            }
            if (obj instanceof IHasProp) {
                for (String propName2 : ((IHasProp)obj).propSet()) {
                    this.props.computeIfAbsent(propName2, n -> () -> ((IHasProp)obj).get((String)n));
                }
            }
            return this;
        }

        public <T> Builder<OUT> elseWith(T obj, Function<? super T, ? extends OUT> method) {
            if (obj instanceof IParameterizedObject) {
                for (String propName : ((IParameterizedObject)obj).propSet()) {
                    this.map.computeIfAbsent(propName, n -> it -> method.apply((Object)((IParameterizedObject)obj).with((String)n, it)));
                }
            }
            if (obj instanceof IHasProp) {
                for (String propName : ((IHasProp)obj).propSet()) {
                    this.props.computeIfAbsent(propName, n -> () -> ((IHasProp)obj).get((String)n));
                }
            }
            return this;
        }

        public <T> Builder<OUT> prop(T obj, Function<? super String, ? extends Object> method) {
            if (obj instanceof IParameterizedObject) {
                for (String propName : ((IParameterizedObject)obj).propSet()) {
                    this.props.computeIfAbsent(propName, n -> () -> method.apply((String)n));
                }
            }
            return this;
        }

        public <T> Builder<OUT> prop(T obj) {
            if (obj instanceof IHasProp) {
                for (String propName : ((IHasProp)obj).propSet()) {
                    this.props.computeIfAbsent(propName, n -> () -> ((IHasProp)obj).get((String)n));
                }
            }
            return this;
        }

        public Prop<OUT> build() {
            return new Prop<OUT>(this.outType, this.map, this.builders, this.props);
        }
    }
}

