/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.commons.names;

import dev.nokee.commons.names.IAppendTo;
import dev.nokee.commons.names.Name;
import dev.nokee.commons.names.NameBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

final class NamingScheme {
    private final List<Segment> segments;

    private NamingScheme(List<Segment> segments) {
        this.segments = segments;
    }

    public Formatter format(final Name name) {
        return new Formatter(){

            @Override
            public String using(Factory<NameBuilder> factory) {
                NameBuilder builder = factory.create();
                for (Segment segment : NamingScheme.this.segments) {
                    segment.format(name).ifPresent(obj -> {
                        if (obj instanceof String) {
                            builder.append((String)obj);
                        } else if (obj instanceof IAppendTo) {
                            ((IAppendTo)obj).appendTo(builder);
                        } else {
                            throw new UnsupportedOperationException();
                        }
                    });
                }
                return builder.toString();
            }
        };
    }

    public static NamingScheme of(Segment ... segments) {
        return new NamingScheme(Arrays.asList(segments));
    }

    public static Segment property(final String property) {
        return new Segment(){

            @Override
            public Optional<Object> format(Name prop) {
                return Optional.ofNullable(prop.get(property));
            }
        };
    }

    public static Segment string(final String s) {
        return new Segment(){

            @Override
            public Optional<Object> format(Name prop) {
                return Optional.of(s);
            }
        };
    }

    public static Segment qualifier() {
        return new Segment(){

            @Override
            public Optional<Object> format(Name prop) {
                return Optional.ofNullable(prop.get("qualifier"));
            }
        };
    }

    public static interface Segment {
        public Optional<Object> format(Name var1);
    }

    public static interface Factory<T> {
        public T create();
    }

    public static interface Formatter {
        public String using(Factory<NameBuilder> var1);
    }
}

