/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.commons.names;

import dev.nokee.commons.names.IAppendTo;
import dev.nokee.commons.names.IHasProp;
import dev.nokee.commons.names.IParameterizedObject;
import dev.nokee.commons.names.Name;
import dev.nokee.commons.names.NameBuilder;
import dev.nokee.commons.names.NamingScheme;
import dev.nokee.commons.names.Prop;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

abstract class NameString
implements IAppendTo,
IParameterizedObject<NameString>,
NamingScheme.Segment,
IHasProp {
    NameString() {
    }

    public static NameString of(NameString ... qualifiers) {
        return new CompositeQualifier(Arrays.asList(qualifiers));
    }

    public static NameString of(Iterable<NameString> qualifiers) {
        return new CompositeQualifier(qualifiers);
    }

    public static NameString of(String value) {
        return new DefaultQualifier(value);
    }

    public static NameString empty() {
        return new EmptyQualifier();
    }

    public static NameString ofMain(NameString qualifier) {
        return new MainQualifier(qualifier);
    }

    public static NameString of(String propName, NameString s) {
        return new PropQualifier(propName, s);
    }

    @Override
    public Optional<Object> format(Name prop) {
        return Optional.of(this);
    }

    private static final class CompositeQualifier
    extends NameString {
        private final List<NameString> qualifiers = new ArrayList<NameString>();
        private final Prop<CompositeQualifier> prop;

        public CompositeQualifier(Iterable<NameString> qualifiers) {
            qualifiers.forEach(this.qualifiers::add);
            Prop.Builder<CompositeQualifier> builder = new Prop.Builder<CompositeQualifier>(CompositeQualifier.class);
            for (NameString q : qualifiers) {
                builder.elseWith(q, it -> new CompositeQualifier(this.qualifiers.stream().map(t -> {
                    if (t.equals(q)) {
                        return it;
                    }
                    return t;
                }).collect(Collectors.toList())));
            }
            this.prop = builder.build();
        }

        @Override
        public Set<String> propSet() {
            return this.prop.names();
        }

        @Override
        public CompositeQualifier with(String propName, Object value) {
            return this.prop.with(propName, value);
        }

        @Override
        public void appendTo(NameBuilder builder) {
            builder.append(it -> {
                for (NameString qualifier : this.qualifiers) {
                    qualifier.appendTo((NameBuilder)it);
                }
            });
        }

        public String toString() {
            NameBuilder builder = NameBuilder.toStringCase();
            this.qualifiers.forEach(it -> it.appendTo(builder));
            return builder.toString();
        }

        @Override
        public Object get(String propName) {
            for (NameString q : this.qualifiers) {
                Object result = q.get(propName);
                if (result == null) continue;
                return result;
            }
            return null;
        }
    }

    private static final class DefaultQualifier
    extends NameString {
        private final String value;

        public DefaultQualifier(String value) {
            this.value = value;
        }

        @Override
        public Set<String> propSet() {
            return Collections.emptySet();
        }

        @Override
        public NameString with(String propName, Object value) {
            return this;
        }

        @Override
        public void appendTo(NameBuilder builder) {
            builder.append(this.value);
        }

        public String toString() {
            return NameBuilder.toStringCase().append(this.value).toString();
        }

        @Override
        public Optional<Object> format(Name prop) {
            return Optional.of(this);
        }

        @Override
        public Object get(String propName) {
            return null;
        }
    }

    private static final class EmptyQualifier
    extends NameString {
        private EmptyQualifier() {
        }

        @Override
        public void appendTo(NameBuilder builder) {
        }

        @Override
        public Set<String> propSet() {
            return Collections.emptySet();
        }

        @Override
        public EmptyQualifier with(String propName, Object value) {
            return this;
        }

        @Override
        public Object get(String propName) {
            return null;
        }
    }

    private static final class MainQualifier
    extends NameString
    implements MainName {
        private final NameString qualifier;

        public MainQualifier(NameString qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        public Set<String> propSet() {
            return Collections.emptySet();
        }

        @Override
        public NameString with(String propName, Object value) {
            return this;
        }

        @Override
        public void appendTo(NameBuilder builder) {
            builder.append(this);
        }

        public String toString() {
            NameBuilder builder = NameBuilder.toStringCase();
            this.qualifier.appendTo(builder);
            return builder.toString();
        }

        @Override
        public NameString delegate() {
            return this.qualifier;
        }

        @Override
        public Object get(String propName) {
            return null;
        }
    }

    private static final class PropQualifier
    extends NameString {
        private final String propName;
        private final NameString delegate;

        private PropQualifier(String propName, NameString delegate) {
            this.propName = propName;
            this.delegate = delegate;
        }

        @Override
        public void appendTo(NameBuilder builder) {
            this.delegate.appendTo(builder);
        }

        @Override
        public Set<String> propSet() {
            return Collections.singleton(this.propName);
        }

        @Override
        public PropQualifier with(String propName, Object value) {
            if (propName.equals(this.propName)) {
                if (value instanceof NameString) {
                    return new PropQualifier(this.propName, (NameString)value);
                }
                if (value instanceof String) {
                    return new PropQualifier(this.propName, NameString.of((String)value));
                }
                throw new IllegalArgumentException("Unsupported qualifier type: " + value);
            }
            return this;
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public Object get(String propName) {
            if (propName.equals(this.propName)) {
                return this.delegate;
            }
            return null;
        }
    }

    static interface MainName {
        public NameString delegate();
    }
}

