/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.commons.names;

import dev.nokee.commons.names.NameString;
import dev.nokee.commons.names.StringUtils;
import java.util.function.Consumer;

interface NameBuilder {
    public NameBuilder append(String var1);

    public NameBuilder append(Consumer<? super NameBuilder> var1);

    public NameBuilder append(NameString.MainName var1);

    public static NameBuilder accordion(final NameBuilder builder) {
        return new NameBuilder(){

            @Override
            public NameBuilder append(String s) {
                builder.append(s);
                return this;
            }

            @Override
            public NameBuilder append(Consumer<? super NameBuilder> action) {
                builder.append((? super NameBuilder it) -> action.accept(this));
                return this;
            }

            @Override
            public NameBuilder append(NameString.MainName name) {
                return this;
            }

            public String toString() {
                return builder.toString();
            }
        };
    }

    public static NameBuilder dirNames() {
        return new NameBuilder(){
            private final StringBuilder result = new StringBuilder();

            @Override
            public NameBuilder append(String s) {
                if (!s.trim().isEmpty()) {
                    this.result.append("/").append(s);
                }
                return this;
            }

            @Override
            public NameBuilder append(Consumer<? super NameBuilder> action) {
                action.accept(NameBuilder.accordion(this));
                return this;
            }

            @Override
            public NameBuilder append(NameString.MainName name) {
                name.delegate().appendTo(this);
                return this;
            }

            public String toString() {
                return this.result.substring(1);
            }
        };
    }

    public static NameBuilder lowerCamelCase() {
        return new NameBuilder(){
            private final StringBuilder result = new StringBuilder();

            @Override
            public NameBuilder append(String s) {
                this.result.append(StringUtils.capitalize(s));
                return this;
            }

            @Override
            public NameBuilder append(Consumer<? super NameBuilder> action) {
                action.accept(this);
                return this;
            }

            @Override
            public NameBuilder append(NameString.MainName name) {
                name.delegate().appendTo(this);
                return this;
            }

            public String toString() {
                return StringUtils.uncapitalize(this.result.toString());
            }
        };
    }

    public static NameBuilder toStringCase() {
        return NameBuilder.accordion(NameBuilder.lowerCamelCase());
    }
}

