/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.commons.names;

import dev.nokee.commons.names.ElementName;
import dev.nokee.commons.names.ForwardingNames;
import dev.nokee.commons.names.FullyQualifiedName;
import dev.nokee.commons.names.Names;
import dev.nokee.commons.names.TaskName;
import org.gradle.api.tasks.SourceSet;

public class JvmNames {
    static ForSourceSet of(SourceSet sourceSet) {
        if (JvmNames.isMain(sourceSet)) {
            return new ForSourceSet(Names.ofMain());
        }
        return new ForSourceSet(Names.of(sourceSet.getName()));
    }

    private static boolean isMain(SourceSet sourceSet) {
        return sourceSet.getName().equals("main");
    }

    public static String compileOnlyApiConfigurationName(SourceSet sourceSet) {
        return JvmNames.of(sourceSet).compileOnlyApiConfigurationName().toString();
    }

    public static String groovydocJarTaskName(SourceSet sourceSet) {
        return JvmNames.of(sourceSet).groovydocJarTaskName().toString();
    }

    public static String groovydocTaskName(SourceSet sourceSet) {
        return JvmNames.of(sourceSet).groovydocTaskName().toString();
    }

    public static String groovydocElementsConfigurationName(SourceSet sourceSet) {
        return JvmNames.of(sourceSet).groovydocElementsConfigurationName().toString();
    }

    public static String pluginUnderTestMetadataTaskName() {
        return ElementName.taskName().forObject("pluginUnderTestMetadata").toString();
    }

    public static String compileKotlinTaskName(SourceSet sourceSet) {
        return JvmNames.of(sourceSet).compileKotlinTaskName().toString();
    }

    public static String compileGroovyTaskName(SourceSet sourceSet) {
        return JvmNames.of(sourceSet).compileGroovyTaskName().toString();
    }

    static class ForSourceSet
    extends ForwardingNames<ForSourceSet>
    implements Names {
        private final Names delegate;

        public ForSourceSet(Names delegate) {
            this.delegate = delegate;
        }

        public FullyQualifiedName annotationProcessorConfigurationName() {
            return this.configurationName("annotationProcessor");
        }

        public FullyQualifiedName apiConfigurationName() {
            return this.configurationName("api");
        }

        public FullyQualifiedName apiElementsConfigurationName() {
            return this.configurationName("apiElements");
        }

        public FullyQualifiedName classesTaskName() {
            return this.taskName((? super TaskName.Builder it) -> it.forObject("classes"));
        }

        public FullyQualifiedName compileClasspathConfigurationName() {
            return this.configurationName("compileClasspath");
        }

        public FullyQualifiedName compileGroovyTaskName() {
            return this.taskName("compile", "groovy");
        }

        public FullyQualifiedName compileJavaTaskName() {
            return this.taskName("compile", "java");
        }

        public FullyQualifiedName compileKotlinTaskName() {
            return this.taskName("compile", "kotlin");
        }

        public FullyQualifiedName compileOnlyApiConfigurationName() {
            return this.configurationName("compileOnlyApi");
        }

        public FullyQualifiedName compileOnlyConfigurationName() {
            return this.configurationName("compileOnly");
        }

        public FullyQualifiedName compileTaskName(String language) {
            return this.taskName("compile", language);
        }

        public FullyQualifiedName groovydocElementsConfigurationName() {
            return this.configurationName("groovydocElements");
        }

        public FullyQualifiedName groovydocJarTaskName() {
            return this.taskName((? super TaskName.Builder it) -> it.forObject("groovydocJar"));
        }

        public FullyQualifiedName groovydocTaskName() {
            return this.taskName((? super TaskName.Builder it) -> it.forObject("groovydoc"));
        }

        public FullyQualifiedName implementationConfigurationName() {
            return this.configurationName("implementation");
        }

        public FullyQualifiedName jarTaskName() {
            return this.taskName((? super TaskName.Builder it) -> it.forObject("jar"));
        }

        public FullyQualifiedName javadocElementsConfigurationName() {
            return this.configurationName("javadocElements");
        }

        public FullyQualifiedName javadocJarTaskName() {
            return this.taskName((? super TaskName.Builder it) -> it.forObject("javadocJar"));
        }

        public FullyQualifiedName javadocTaskName() {
            return this.taskName((? super TaskName.Builder it) -> it.forObject("javadoc"));
        }

        public FullyQualifiedName pluginUnderTestMetadataTaskName() {
            return this.taskName((? super TaskName.Builder it) -> it.forObject("pluginUnderTestMetadata"));
        }

        public FullyQualifiedName processResourcesTaskName() {
            return this.taskName("process", "resources");
        }

        public FullyQualifiedName runtimeClasspathConfigurationName() {
            return this.configurationName("runtimeClasspath");
        }

        public FullyQualifiedName runtimeElementsConfigurationName() {
            return this.configurationName("runtimeElements");
        }

        public FullyQualifiedName runtimeOnlyConfigurationName() {
            return this.configurationName("runtimeOnly");
        }

        public FullyQualifiedName sourcesElementsConfigurationName() {
            return this.configurationName("sourcesElements");
        }

        public FullyQualifiedName sourcesJarTaskName() {
            return this.taskName((? super TaskName.Builder it) -> it.forObject("sourcesJar"));
        }

        @Override
        protected Names delegate() {
            return this.delegate;
        }
    }
}

