/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.commons.names;

import dev.nokee.commons.names.DefaultRelativeName;
import dev.nokee.commons.names.FullyQualifiedName;
import dev.nokee.commons.names.NameBuilder;
import dev.nokee.commons.names.NameSupport;
import dev.nokee.commons.names.QualifiedName;
import dev.nokee.commons.names.Qualifier;
import dev.nokee.commons.names.RelativeName;
import dev.nokee.commons.names.StringUtils;
import org.gradle.api.Named;

final class GradleNamedAdapter
extends NameSupport<GradleNamedAdapter>
implements FullyQualifiedName {
    private final Named obj;

    public GradleNamedAdapter(Named obj) {
        this.obj = obj;
    }

    @Override
    public String toString() {
        return this.obj.getName();
    }

    @Override
    public String toString(NameBuilder builder) {
        return builder.append(this.obj.getName()).toString();
    }

    @Override
    public RelativeName relativeTo(Qualifier qualifier) {
        if (this.obj.getName().startsWith(qualifier.toString())) {
            String relName = this.obj.getName().substring(qualifier.toString().length());
            return new DefaultRelativeName(this, new QualifiedStringName(relName));
        }
        String capitalizedQualifier = StringUtils.capitalize(qualifier.toString());
        if (this.obj.getName().contains(capitalizedQualifier)) {
            String relName = this.obj.getName().replace(capitalizedQualifier, "");
            return new DefaultRelativeName(this, new QualifiedStringName(relName));
        }
        throw new UnsupportedOperationException("not relative");
    }

    private static final class QualifiedStringName
    extends NameSupport<QualifiedName>
    implements QualifiedName {
        private final String relativeName;

        private QualifiedStringName(String relativeName) {
            this.relativeName = relativeName;
        }

        @Override
        public String toString(NameBuilder builder) {
            return builder.append(this.relativeName).toString();
        }

        @Override
        public String toString() {
            return this.relativeName;
        }
    }
}

