/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.commons.names;

import dev.nokee.commons.names.FullyQualifiedName;
import dev.nokee.commons.names.NameBuilder;
import dev.nokee.commons.names.NameSupport;
import dev.nokee.commons.names.Prop;
import dev.nokee.commons.names.QualifiedName;
import dev.nokee.commons.names.Qualifier;
import dev.nokee.commons.names.RelativeName;
import java.util.ArrayList;

final class DefaultRelativeName
extends NameSupport<DefaultRelativeName>
implements RelativeName {
    private final FullyQualifiedName fullName;
    private final QualifiedName relativeName;

    public DefaultRelativeName(FullyQualifiedName fullName, QualifiedName relativeName) {
        this.fullName = fullName;
        this.relativeName = relativeName;
    }

    @Override
    void init(Prop.Builder<DefaultRelativeName> builder) {
        builder.prop(this.relativeName);
    }

    @Override
    public FullyQualifiedName toFullName() {
        return this.fullName;
    }

    @Override
    public String toString(NameBuilder builder) {
        return this.relativeName.toString(builder);
    }

    @Override
    public String toString() {
        return this.toString(NameBuilder.toStringCase());
    }

    static Qualifier relativeTo(Qualifier self, Qualifier qualifier) {
        final ArrayList rel = new ArrayList();
        qualifier.accept(new Qualifier.Visitor(){

            @Override
            public void visit(Qualifier qualifier) {
                rel.add(qualifier);
            }
        });
        final ArrayList full = new ArrayList();
        self.accept(new Qualifier.Visitor(){

            @Override
            public void visit(Qualifier qualifier) {
                full.add(qualifier);
            }
        });
        while (!rel.isEmpty() && ((Qualifier)rel.get(0)).equals(full.get(0))) {
            rel.remove(0);
            full.remove(0);
        }
        if (!rel.isEmpty()) {
            throw new IllegalArgumentException("This name is not relative to specified qualifier.");
        }
        return builder -> full.forEach(it -> it.appendTo(builder));
    }
}

