/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.commons.names;

import dev.nokee.commons.names.DefaultRelativeName;
import dev.nokee.commons.names.ElementName;
import dev.nokee.commons.names.FullyQualifiedName;
import dev.nokee.commons.names.NameBuilder;
import dev.nokee.commons.names.NameSupport;
import dev.nokee.commons.names.NamingScheme;
import dev.nokee.commons.names.OtherName;
import dev.nokee.commons.names.Prop;
import dev.nokee.commons.names.Qualifier;
import dev.nokee.commons.names.QualifyingName;
import dev.nokee.commons.names.RelativeName;

final class DefaultQualifyingName
extends NameSupport<FullyQualifiedName>
implements QualifyingName {
    private final Qualifier qualifier;
    private final OtherName elementName;
    private final NamingScheme scheme;

    public DefaultQualifyingName(Qualifier qualifier, OtherName elementName, NamingScheme scheme) {
        this.qualifier = qualifier;
        this.elementName = elementName;
        this.scheme = scheme;
    }

    @Override
    void init(Prop.Builder<FullyQualifiedName> builder) {
        builder.with("qualifier", this::withQualifier, this::getQualifier).with("elementName", this::withElementName, this::getElementName);
    }

    public DefaultQualifyingName withQualifier(Qualifier qualifier) {
        return new DefaultQualifyingName(qualifier, this.elementName, this.scheme);
    }

    public Qualifier getQualifier() {
        return this.qualifier;
    }

    public FullyQualifiedName withElementName(ElementName elementName) {
        return elementName.qualifiedBy(this.qualifier);
    }

    public ElementName getElementName() {
        return this.elementName;
    }

    @Override
    public void appendTo(NameBuilder builder) {
        this.qualifier.appendTo(builder);
        this.elementName.appendTo(builder);
    }

    @Override
    public String toString() {
        return this.scheme.format(this).using(NameBuilder::toStringCase);
    }

    @Override
    public String toString(NameBuilder builder) {
        return this.scheme.format(this).using(() -> builder);
    }

    @Override
    public RelativeName relativeTo(Qualifier qualifier) {
        return new DefaultRelativeName(this, this.elementName.qualifiedBy(DefaultRelativeName.relativeTo(this.qualifier, qualifier)));
    }

    @Override
    public void accept(Qualifier.Visitor visitor) {
        this.qualifier.accept(visitor);
        visitor.visit(this.elementName);
    }
}

