/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.commons.names;

import dev.nokee.commons.names.DefaultRelativeName;
import dev.nokee.commons.names.ElementName;
import dev.nokee.commons.names.FullyQualifiedName;
import dev.nokee.commons.names.NameBuilder;
import dev.nokee.commons.names.NameSupport;
import dev.nokee.commons.names.NamingScheme;
import dev.nokee.commons.names.Prop;
import dev.nokee.commons.names.Qualifier;
import dev.nokee.commons.names.RelativeName;

final class DefaultFullyQualifiedName
extends NameSupport<FullyQualifiedName>
implements FullyQualifiedName {
    private final Qualifier qualifier;
    private final ElementName elementName;
    private final NamingScheme scheme;

    public DefaultFullyQualifiedName(Qualifier qualifier, ElementName elementName, NamingScheme scheme) {
        this.qualifier = qualifier;
        this.elementName = elementName;
        this.scheme = scheme;
    }

    @Override
    void init(Prop.Builder<FullyQualifiedName> builder) {
        builder.with("qualifier", this::withQualifier, this::getQualifier).with("elementName", this::withElementName, this::getElementName);
    }

    public DefaultFullyQualifiedName withQualifier(Qualifier qualifier) {
        return new DefaultFullyQualifiedName(qualifier, this.elementName, this.scheme);
    }

    public Qualifier getQualifier() {
        return this.qualifier;
    }

    public FullyQualifiedName withElementName(ElementName elementName) {
        return elementName.qualifiedBy(this.qualifier);
    }

    public ElementName getElementName() {
        return this.elementName;
    }

    @Override
    public String toString() {
        return this.scheme.format(this).using(NameBuilder::toStringCase);
    }

    @Override
    public String toString(NameBuilder builder) {
        return this.scheme.format(this).using(() -> builder);
    }

    @Override
    public RelativeName relativeTo(Qualifier qualifier) {
        return new DefaultRelativeName(this, this.elementName.qualifiedBy(DefaultRelativeName.relativeTo(this.qualifier, qualifier)));
    }
}

