/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.commons.names;

import dev.nokee.commons.names.DefaultNames;
import dev.nokee.commons.names.ElementName;
import dev.nokee.commons.names.ForwardingNames;
import dev.nokee.commons.names.FullyQualifiedName;
import dev.nokee.commons.names.NameString;
import dev.nokee.commons.names.Names;
import dev.nokee.commons.names.OtherElementName;
import dev.nokee.commons.names.QualifyingName;
import dev.nokee.commons.names.StringUtils;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.gradle.api.Named;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppComponent;
import org.gradle.language.cpp.CppSharedLibrary;
import org.gradle.language.cpp.CppStaticLibrary;
import org.gradle.nativeplatform.test.cpp.CppTestExecutable;

public final class CppNames {
    private static final CppNames INSTANCE = new CppNames();

    public static ForBinary of(CppBinary binary) {
        return new ForBinary(binary);
    }

    public static ForComponent of(CppComponent component) {
        return new ForComponent(component);
    }

    public static QualifyingName qualifyingName(Named componentOrBinary) {
        NameSegmentIterator iter = new NameSegmentIterator(componentOrBinary);
        Names result = null;
        result = iter.consumeNext("main", "test").map(it -> {
            if (it.equals("main")) {
                return Names.ofMain();
            }
            if (it.equals("test")) {
                return Names.of("test");
            }
            return null;
        }).orElseThrow(() -> new IllegalStateException("Could not find main or test"));
        ArrayList<NameString> binaryName = new ArrayList<NameString>();
        CppNames.or(iter.consumeNext("debug", "release").map(NameString::of), () -> {
            if (componentOrBinary instanceof CppTestExecutable) {
                CppBinary binary = (CppBinary)componentOrBinary;
                if (binary.isOptimized()) {
                    return Optional.of(NameString.ofMain(NameString.of("release")));
                }
                return Optional.of(NameString.ofMain(NameString.of("debug")));
            }
            return Optional.of(NameString.empty());
        }).map(it -> NameString.of("buildTypeName", it)).ifPresent(binaryName::add);
        CppNames.or(iter.consumeNext("shared", "static").map(NameString::of), () -> {
            if (componentOrBinary instanceof CppSharedLibrary) {
                return Optional.of(NameString.ofMain(NameString.of("shared")));
            }
            if (componentOrBinary instanceof CppStaticLibrary) {
                return Optional.of(NameString.ofMain(NameString.of("static")));
            }
            return Optional.of(NameString.empty());
        }).map(it -> NameString.of("linkageName", it)).ifPresent(binaryName::add);
        CppNames.or(iter.consumeNext("linux", "macos", "windows").map(NameString::of), () -> {
            if (componentOrBinary instanceof CppBinary) {
                CppBinary binary = (CppBinary)componentOrBinary;
                return Optional.of(NameString.ofMain(NameString.of(binary.getTargetMachine().getOperatingSystemFamily().getName())));
            }
            return Optional.of(NameString.empty());
        }).map(it -> NameString.of("osFamilyName", it)).ifPresent(binaryName::add);
        CppNames.or(iter.consumeNext("x86", "x86-64", "aarch64").map(NameString::of), () -> {
            if (componentOrBinary instanceof CppBinary) {
                CppBinary binary = (CppBinary)componentOrBinary;
                return Optional.of(NameString.ofMain(NameString.of(binary.getTargetMachine().getArchitecture().getName())));
            }
            return Optional.of(NameString.empty());
        }).map(it -> NameString.of("architectureName", it)).ifPresent(binaryName::add);
        if (binaryName.isEmpty()) {
            return result;
        }
        return result.append(new OtherElementName(NameString.of(binaryName)));
    }

    private static <T> Optional<T> or(Optional<T> self, Supplier<? extends Optional<? extends T>> supplier) {
        Objects.requireNonNull(supplier);
        if (self.isPresent()) {
            return self;
        }
        Optional<? extends T> r = supplier.get();
        return Objects.requireNonNull(r);
    }

    ForComponentBuilder cppApiElementsConfigurationName() {
        return component -> ElementName.configurationName("cppApiElements").qualifiedBy(CppNames.qualifyingName((Named)component));
    }

    ImplementationConfigurationNameBuilder implementationConfigurationName() {
        return new ImplementationConfigurationNameBuilder(){

            @Override
            public FullyQualifiedName forBinary(CppBinary binary) {
                return ElementName.configurationName("implementation").qualifiedBy(builder -> builder.append(binary.getName()));
            }

            @Override
            public FullyQualifiedName forComponent(CppComponent component) {
                return ElementName.configurationName("implementation").qualifiedBy(CppNames.qualifyingName((Named)component));
            }
        };
    }

    ForComponentBuilder apiConfigurationName() {
        return component -> ElementName.configurationName("api").qualifiedBy(CppNames.qualifyingName((Named)component));
    }

    ForBinaryBuilder linkElementsConfigurationName() {
        return binary -> ElementName.configurationName("linkElements").qualifiedBy(CppNames.qualifyingName((Named)binary));
    }

    ForBinaryBuilder runtimeElementsConfigurationName() {
        return binary -> ElementName.configurationName("runtimeElements").qualifiedBy(CppNames.qualifyingName((Named)binary));
    }

    ForBinaryBuilder nativeLinkConfigurationName() {
        return binary -> ElementName.configurationName().prefix("nativeLink").qualifiedBy(CppNames.qualifyingName((Named)binary));
    }

    ForBinaryBuilder nativeRuntimeConfigurationName() {
        return binary -> ElementName.configurationName().prefix("nativeRuntime").qualifiedBy(CppNames.qualifyingName((Named)binary));
    }

    ForBinaryBuilder cppCompileConfigurationName() {
        return binary -> ElementName.configurationName().prefix("cppCompile").qualifiedBy(CppNames.qualifyingName((Named)binary));
    }

    ForBinaryBuilder compileTaskName() {
        return binary -> ElementName.taskName("compile", "cpp").qualifiedBy(CppNames.qualifyingName((Named)binary));
    }

    ForBinaryBuilder compileTaskName(String language) {
        return binary -> ElementName.taskName("compile", language).qualifiedBy(CppNames.qualifyingName((Named)binary));
    }

    ForBinaryBuilder linkTaskName() {
        return binary -> ElementName.taskName("link").qualifiedBy(CppNames.qualifyingName((Named)binary));
    }

    public static String cppApiElementsConfigurationName(CppComponent component) {
        return CppNames.of(component).cppApiElementsConfigurationName().toString();
    }

    public static String implementationConfigurationName(CppComponent component) {
        return CppNames.of(component).implementationConfigurationName().toString();
    }

    public static String apiConfigurationName(CppComponent component) {
        return CppNames.of(component).apiConfigurationName().toString();
    }

    public static String implementationConfigurationName(CppBinary binary) {
        return CppNames.of(binary).implementationConfigurationName().toString();
    }

    public static String linkElementsConfigurationName(CppBinary binary) {
        return CppNames.of(binary).linkElementsConfigurationName().toString();
    }

    public static String runtimeElementsConfigurationName(CppBinary binary) {
        return CppNames.of(binary).runtimeElementsConfigurationName().toString();
    }

    public static String nativeLinkConfigurationName(CppBinary binary) {
        return CppNames.of(binary).nativeLinkConfigurationName().toString();
    }

    public static String nativeRuntimeConfigurationName(CppBinary binary) {
        return CppNames.of(binary).nativeRuntimeConfigurationName().toString();
    }

    public static String compileTaskName(CppBinary binary) {
        return CppNames.of(binary).compileTaskName().toString();
    }

    public static String compileTaskName(CppBinary binary, String language) {
        return CppNames.of(binary).compileTaskName(language).toString();
    }

    public static String linkTaskName(CppBinary binary) {
        return CppNames.of(binary).linkTaskName().toString();
    }

    public static String cppCompileConfigurationName(CppBinary binary) {
        return CppNames.of(binary).cppCompileConfigurationName().toString();
    }

    public static class ForBinary
    extends ForwardingNames<ForBinary>
    implements Names {
        private final Names delegate;
        private final CppBinary binary;

        private ForBinary(CppBinary binary) {
            this.binary = binary;
            this.delegate = new DefaultNames(CppNames.qualifyingName((Named)binary));
        }

        public FullyQualifiedName linkElementsConfigurationName() {
            return INSTANCE.linkElementsConfigurationName().forBinary(this.binary);
        }

        public FullyQualifiedName runtimeElementsConfigurationName() {
            return INSTANCE.runtimeElementsConfigurationName().forBinary(this.binary);
        }

        public FullyQualifiedName nativeLinkConfigurationName() {
            return INSTANCE.nativeLinkConfigurationName().forBinary(this.binary);
        }

        public FullyQualifiedName nativeRuntimeConfigurationName() {
            return INSTANCE.nativeRuntimeConfigurationName().forBinary(this.binary);
        }

        public FullyQualifiedName compileTaskName() {
            return INSTANCE.compileTaskName().forBinary(this.binary);
        }

        public FullyQualifiedName compileTaskName(String language) {
            return INSTANCE.compileTaskName(language).forBinary(this.binary);
        }

        public FullyQualifiedName linkTaskName() {
            return INSTANCE.linkTaskName().forBinary(this.binary);
        }

        public FullyQualifiedName implementationConfigurationName() {
            return INSTANCE.implementationConfigurationName().forBinary(this.binary);
        }

        public FullyQualifiedName cppCompileConfigurationName() {
            return INSTANCE.cppCompileConfigurationName().forBinary(this.binary);
        }

        @Override
        protected Names delegate() {
            return this.delegate;
        }
    }

    public static final class ForComponent
    extends ForwardingNames<ForComponent>
    implements Names {
        private final Names delegate;
        private final CppComponent component;

        private ForComponent(CppComponent component) {
            this.component = component;
            this.delegate = new DefaultNames(CppNames.qualifyingName((Named)component));
        }

        public FullyQualifiedName cppApiElementsConfigurationName() {
            return INSTANCE.cppApiElementsConfigurationName().forComponent(this.component);
        }

        public FullyQualifiedName implementationConfigurationName() {
            return INSTANCE.implementationConfigurationName().forComponent(this.component);
        }

        public FullyQualifiedName apiConfigurationName() {
            return INSTANCE.apiConfigurationName().forComponent(this.component);
        }

        @Override
        protected Names delegate() {
            return this.delegate;
        }
    }

    private static class NameSegmentIterator {
        private String name;

        private NameSegmentIterator(Named obj) {
            this.name = obj.getName();
        }

        public Optional<String> consumeNext(String ... words) {
            for (String word : words) {
                if (!this.name.startsWith(word)) continue;
                this.name = StringUtils.uncapitalize(this.name.substring(word.length()));
                return Optional.of(word);
            }
            return Optional.empty();
        }
    }

    static interface ForComponentBuilder {
        public FullyQualifiedName forComponent(CppComponent var1);
    }

    static interface ForBinaryBuilder {
        public FullyQualifiedName forBinary(CppBinary var1);
    }

    static interface ImplementationConfigurationNameBuilder
    extends ForComponentBuilder,
    ForBinaryBuilder {
    }
}

