/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.commons.names;

import dev.nokee.commons.names.DefaultFullyQualifiedName;
import dev.nokee.commons.names.ElementName;
import dev.nokee.commons.names.FullyQualifiedName;
import dev.nokee.commons.names.NameBuilder;
import dev.nokee.commons.names.NameSupport;
import dev.nokee.commons.names.NamingScheme;
import dev.nokee.commons.names.Qualifier;

public final class ConfigurationName
extends NameSupport<ConfigurationName>
implements ElementName {
    private final NamingScheme scheme;

    private ConfigurationName(NamingScheme scheme) {
        this.scheme = scheme;
    }

    static ConfigurationName of(String name) {
        return new ConfigurationName(NamingScheme.of(NamingScheme.qualifier(), NamingScheme.string(name)));
    }

    @Override
    public String toString() {
        return this.scheme.format(this).using(NameBuilder::toStringCase);
    }

    @Override
    public FullyQualifiedName qualifiedBy(Qualifier qualifier) {
        return new DefaultFullyQualifiedName(qualifier, this, this.scheme);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Builder() {
        }

        public ConfigurationName prefix(String name) {
            return new ConfigurationName(NamingScheme.of(NamingScheme.string(name), NamingScheme.qualifier()));
        }
    }
}

