/*
 * Decompiled with CFR 0.152.
 */
package dev.nipafx.args;

import dev.nipafx.args.AbstractArg;
import dev.nipafx.args.Arg;
import java.util.Optional;

final class OptionalArg<T>
extends AbstractArg<Optional>
implements Arg<Optional> {
    private final Class<T> valueType;
    private Optional<T> value;

    OptionalArg(String name, Class<T> valueType) {
        super(name, Optional.class);
        this.valueType = valueType;
        this.value = Optional.empty();
    }

    @Override
    public void setValue(String value) throws IllegalArgumentException {
        this.value = Optional.of(OptionalArg.parseValueToType(value, this.valueType));
    }

    @Override
    public Optional<Optional> value() {
        return Optional.of(this.value);
    }
}

