/*
 * Decompiled with CFR 0.152.
 */
package dev.nipafx.args;

import dev.nipafx.args.AbstractArg;
import dev.nipafx.args.Arg;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

final class MapArg<K, V>
extends AbstractArg<Map>
implements Arg<Map> {
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final Map<K, V> values;

    MapArg(String name, Class<K> keyType, Class<V> valueType) {
        super(name, Map.class);
        this.keyType = keyType;
        this.valueType = valueType;
        this.values = new HashMap();
    }

    @Override
    public void setValue(String keyValue) throws IllegalArgumentException {
        String[] pair = keyValue.split("=");
        if (pair.length == 1) {
            String message = "Map argument '%s' is no valid 'key=value' pair - it has no value.".formatted(keyValue);
            throw new IllegalArgumentException(message);
        }
        if (pair.length > 2) {
            String message = "Map argument '%s' is no valid 'key=value' pair - it has more than one equal sign.".formatted(keyValue);
            throw new IllegalArgumentException(message);
        }
        K key = MapArg.parseValueToType(pair[0], this.keyType);
        V value = MapArg.parseValueToType(pair[1], this.valueType);
        this.values.put(key, value);
    }

    @Override
    public Optional<Map> value() {
        return Optional.of(Map.copyOf(this.values));
    }
}

