/*
 * Decompiled with CFR 0.152.
 */
package dev.nipafx.args;

import dev.nipafx.args.AbstractArg;
import dev.nipafx.args.Arg;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

final class ListArg<T>
extends AbstractArg<List>
implements Arg<List> {
    private final Class<T> valueType;
    private final List<T> values;

    ListArg(String name, Class<T> valueType) {
        super(name, List.class);
        this.valueType = valueType;
        this.values = new ArrayList<T>();
    }

    @Override
    public void setValue(String value) throws IllegalArgumentException {
        this.values.add(ListArg.parseValueToType(value, this.valueType));
    }

    @Override
    public Optional<List> value() {
        return Optional.of(List.copyOf(this.values));
    }
}

