/*
 * Decompiled with CFR 0.152.
 */
package dev.nipafx.args;

import dev.nipafx.args.ArgsMessage;
import dev.nipafx.args.Check;
import dev.nipafx.args.InternalArgsException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ArgsParseException
extends Exception {
    private final String[] args;
    private final List<? extends Class<?>> types;
    private final List<ArgsMessage> errors;

    ArgsParseException(String[] args, Collection<? extends Class<?>> types, InternalArgsException cause) {
        super(ArgsParseException.combineErrors(cause.errors()), cause.getCause());
        this.args = Check.internalErrorOnNull(args);
        this.types = List.copyOf(types);
        this.errors = List.copyOf(cause.errors());
    }

    private static String combineErrors(Collection<ArgsMessage> errors) {
        return errors.stream().map(ArgsMessage::toMessage).collect(Collectors.joining(" "));
    }

    public String[] args() {
        return this.args;
    }

    public List<? extends Class<?>> types() {
        return this.types;
    }

    public Stream<ArgsMessage> errors() {
        return this.errors.stream();
    }
}

